/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.cardiac.common.entities;

import it.hurts.octostudios.cardiac.common.entities.LifeOrb;
import it.hurts.octostudios.cardiac.common.init.EntityRegistry;
import it.hurts.octostudios.cardiac.common.init.ItemRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownLifeBottle
extends ThrowableItemProjectile {
    public ThrownLifeBottle(EntityType<? extends ThrownLifeBottle> type, Level level) {
        super(type, level);
    }

    protected Item getDefaultItem() {
        return (Item)ItemRegistry.LIFE_BOTTLE.get();
    }

    public double getDefaultGravity() {
        return 0.07;
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (this.level() instanceof ServerLevel) {
            this.level().levelEvent(2002, this.blockPosition(), PotionContents.getColor((Holder)Potions.HEALING));
            int steps = 5 + this.random.nextInt(10);
            for (int i = 0; i < steps; ++i) {
                LifeOrb orb = new LifeOrb((EntityType<? extends LifeOrb>)((EntityType)EntityRegistry.LIFE_ORB.get()), this.level());
                orb.setLife(1.0f + this.random.nextFloat() * 3.0f);
                orb.setPos(Vec3.atCenterOf((Vec3i)this.blockPosition()));
                orb.setDeltaMovement((-1.0f + 2.0f * this.random.nextFloat()) * 0.15f, 0.1f + this.random.nextFloat() * 0.2f, (-1.0f + 2.0f * this.random.nextFloat()) * 0.15f);
                this.level().addFreshEntity((Entity)orb);
            }
            this.discard();
        }
    }
}

