/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.cardiac.common.entities;

import it.hurts.octostudios.cardiac.common.init.ConfigRegistry;
import it.hurts.octostudios.cardiac.common.init.SoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class LifeOrb
extends Entity {
    private static final EntityDataAccessor<Float> LIFE = SynchedEntityData.defineId(LifeOrb.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);

    public LifeOrb(EntityType<? extends LifeOrb> type, Level level) {
        super(type, level);
    }

    public float getMaxLife() {
        return (float)ConfigRegistry.CONFIG.getMaxOrbHealth();
    }

    public float getLife() {
        return ((Float)this.getEntityData().get(LIFE)).floatValue();
    }

    public void setLife(float life) {
        this.getEntityData().set(LIFE, (Object)Float.valueOf(life));
    }

    public int getStage() {
        int stages = 5;
        return Mth.clamp((int)(this.getLife() <= 1.0f ? 1 : (int)Math.ceil(Math.min(this.getLife() / (this.getMaxLife() / (float)Math.max(1, stages - 1)) + 1.0f, (float)stages))), (int)1, (int)stages);
    }

    public void tick() {
        super.tick();
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
        }
        if (!this.level().noCollision(this.getBoundingBox())) {
            this.moveTowardsClosestSpace(this.getX(), (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.getZ());
        }
        if (this.tickCount >= 20 && this.getLife() < this.getMaxLife()) {
            for (LifeOrb orb : this.level().getEntitiesOfClass(LifeOrb.class, this.getBoundingBox().inflate(0.25))) {
                if (orb.getUUID().equals(this.getUUID()) || orb.isRemoved() || orb.getLife() >= this.getMaxLife()) continue;
                float diff = this.getMaxLife() - this.getLife();
                if (orb.getLife() < diff) {
                    this.setLife(this.getLife() + orb.getLife());
                    orb.discard();
                    continue;
                }
                orb.setLife(orb.getLife() - diff);
                this.setLife(this.getMaxLife());
            }
        }
        double maxDistance = ConfigRegistry.CONFIG.getOrbFollowDistance();
        Player player = this.level().getNearestPlayer(this.getX(), this.getY(), this.getZ(), maxDistance, entity -> {
            Player entry = (Player)entity;
            return !entry.isSpectator() && (ConfigRegistry.CONFIG.isAttractToFullHP() || entry.getHealth() < entry.getMaxHealth());
        });
        if (player != null) {
            this.setDeltaMovement(this.getDeltaMovement().add(player.position().add(0.0, (double)(player.getBbHeight() / 2.0f), 0.0).subtract(this.position()).normalize().scale((maxDistance - this.position().distanceTo(player.position())) / (maxDistance * 8.0))));
            if (this.position().distanceTo(player.position()) <= (double)player.getBbWidth() && (ConfigRegistry.CONFIG.isAttractToFullHP() || player.getHealth() < player.getMaxHealth())) {
                float diff = player.getMaxHealth() - player.getHealth();
                if (this.getLife() > diff && !ConfigRegistry.CONFIG.isAttractToFullHP()) {
                    this.setLife(this.getLife() - diff);
                    player.heal(diff);
                } else {
                    player.heal(this.getLife());
                    this.discard();
                }
                this.level().playSound(null, this.blockPosition(), (SoundEvent)SoundRegistry.LIFE_ORB_PICKUP.get(), SoundSource.MASTER, 0.5f, 1.25f + this.level().getRandom().nextFloat() * 0.75f);
            }
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        float friction = 0.98f;
        if (this.onGround()) {
            BlockPos pos = this.getBlockPosBelowThatAffectsMyMovement();
            friction = this.level().getBlockState(pos).getBlock().getFriction() * 0.98f;
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)friction, 0.98, (double)friction));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, -0.9, 1.0));
        }
        if (this.tickCount >= ConfigRegistry.CONFIG.getOrbLifetime() * 20) {
            this.discard();
        }
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.setLife(tag.getFloat("life"));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putFloat("life", this.getLife());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(LIFE, (Object)Float.valueOf(1.0f));
    }

    public BlockPos getBlockPosBelowThatAffectsMyMovement() {
        return this.getOnPos(0.999f);
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public boolean isAttackable() {
        return false;
    }

    public SoundSource getSoundSource() {
        return SoundSource.AMBIENT;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        if (LIFE.equals(pKey)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(pKey);
    }

    public EntityDimensions getDimensions(Pose pPose) {
        float scale = 0.075f + (float)this.getStage() * 0.035f;
        return EntityDimensions.scalable((float)scale, (float)scale);
    }
}

