/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.cardiac.common.config;

import it.hurts.octostudios.octolib.module.config.annotation.Prop;
import it.hurts.octostudios.octolib.module.config.impl.OctoConfig;
import java.util.LinkedHashMap;
import java.util.Map;

public class CardiacConfig
implements OctoConfig {
    @Prop(comment="Should life orbs drop when a mob is killed only by a player, or should whenever it dies")
    private boolean shouldBeKilledByPlayer = true;
    @Prop(comment="Should life orbs be attracted to the player even if their health is already full")
    private boolean attractToFullHP = true;
    @Prop(comment="Defines pairs where the key is either a mob's ID or a regex for matching mob IDs, and the value is the percentage of the slain entity's maximum health that will be stored in the life orbs")
    private Map<String, Double> generalPercentages = new LinkedHashMap<String, Double>(){
        {
            this.put(".*", 0.15);
        }
    };
    @Prop(comment="Defines pairs where the key is either a mob's ID or a regex for matching mob IDs, and the value is the extra percentage of the slain entity's maximum health added to the life orbs for each level of the Lifesteal enchantment")
    private Map<String, Double> lifestealPercentages = new LinkedHashMap<String, Double>(){
        {
            this.put(".*", 0.1);
        }
    };
    @Prop(comment="The minimum number of life orbs dropped from a slain entity. This does not affect the total amount of health they will collectively restore")
    private int minOrbsAmount = 2;
    @Prop(comment="The maximum amount of health carried by a life orb")
    private double maxOrbHealth = 10.0;
    @Prop(comment="Time in seconds before the removal of the life orb")
    private int orbLifetime = 60;
    @Prop(comment="The maximum distance in blocks from which a life orb can be attracted to the nearest player")
    private int orbFollowDistance = 8;

    public boolean isShouldBeKilledByPlayer() {
        return this.shouldBeKilledByPlayer;
    }

    public boolean isAttractToFullHP() {
        return this.attractToFullHP;
    }

    public Map<String, Double> getGeneralPercentages() {
        return this.generalPercentages;
    }

    public Map<String, Double> getLifestealPercentages() {
        return this.lifestealPercentages;
    }

    public int getMinOrbsAmount() {
        return this.minOrbsAmount;
    }

    public double getMaxOrbHealth() {
        return this.maxOrbHealth;
    }

    public int getOrbLifetime() {
        return this.orbLifetime;
    }

    public int getOrbFollowDistance() {
        return this.orbFollowDistance;
    }

    public void setShouldBeKilledByPlayer(boolean shouldBeKilledByPlayer) {
        this.shouldBeKilledByPlayer = shouldBeKilledByPlayer;
    }

    public void setAttractToFullHP(boolean attractToFullHP) {
        this.attractToFullHP = attractToFullHP;
    }

    public void setGeneralPercentages(Map<String, Double> generalPercentages) {
        this.generalPercentages = generalPercentages;
    }

    public void setLifestealPercentages(Map<String, Double> lifestealPercentages) {
        this.lifestealPercentages = lifestealPercentages;
    }

    public void setMinOrbsAmount(int minOrbsAmount) {
        this.minOrbsAmount = minOrbsAmount;
    }

    public void setMaxOrbHealth(double maxOrbHealth) {
        this.maxOrbHealth = maxOrbHealth;
    }

    public void setOrbLifetime(int orbLifetime) {
        this.orbLifetime = orbLifetime;
    }

    public void setOrbFollowDistance(int orbFollowDistance) {
        this.orbFollowDistance = orbFollowDistance;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CardiacConfig)) {
            return false;
        }
        CardiacConfig other = (CardiacConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isShouldBeKilledByPlayer() != other.isShouldBeKilledByPlayer()) {
            return false;
        }
        if (this.isAttractToFullHP() != other.isAttractToFullHP()) {
            return false;
        }
        if (this.getMinOrbsAmount() != other.getMinOrbsAmount()) {
            return false;
        }
        if (Double.compare(this.getMaxOrbHealth(), other.getMaxOrbHealth()) != 0) {
            return false;
        }
        if (this.getOrbLifetime() != other.getOrbLifetime()) {
            return false;
        }
        if (this.getOrbFollowDistance() != other.getOrbFollowDistance()) {
            return false;
        }
        Map<String, Double> this$generalPercentages = this.getGeneralPercentages();
        Map<String, Double> other$generalPercentages = other.getGeneralPercentages();
        if (this$generalPercentages == null ? other$generalPercentages != null : !((Object)this$generalPercentages).equals(other$generalPercentages)) {
            return false;
        }
        Map<String, Double> this$lifestealPercentages = this.getLifestealPercentages();
        Map<String, Double> other$lifestealPercentages = other.getLifestealPercentages();
        return !(this$lifestealPercentages == null ? other$lifestealPercentages != null : !((Object)this$lifestealPercentages).equals(other$lifestealPercentages));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CardiacConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isShouldBeKilledByPlayer() ? 79 : 97);
        result = result * 59 + (this.isAttractToFullHP() ? 79 : 97);
        result = result * 59 + this.getMinOrbsAmount();
        long $maxOrbHealth = Double.doubleToLongBits(this.getMaxOrbHealth());
        result = result * 59 + (int)($maxOrbHealth >>> 32 ^ $maxOrbHealth);
        result = result * 59 + this.getOrbLifetime();
        result = result * 59 + this.getOrbFollowDistance();
        Map<String, Double> $generalPercentages = this.getGeneralPercentages();
        result = result * 59 + ($generalPercentages == null ? 43 : ((Object)$generalPercentages).hashCode());
        Map<String, Double> $lifestealPercentages = this.getLifestealPercentages();
        result = result * 59 + ($lifestealPercentages == null ? 43 : ((Object)$lifestealPercentages).hashCode());
        return result;
    }

    public String toString() {
        return "CardiacConfig(shouldBeKilledByPlayer=" + this.isShouldBeKilledByPlayer() + ", attractToFullHP=" + this.isAttractToFullHP() + ", generalPercentages=" + String.valueOf(this.getGeneralPercentages()) + ", lifestealPercentages=" + String.valueOf(this.getLifestealPercentages()) + ", minOrbsAmount=" + this.getMinOrbsAmount() + ", maxOrbHealth=" + this.getMaxOrbHealth() + ", orbLifetime=" + this.getOrbLifetime() + ", orbFollowDistance=" + this.getOrbFollowDistance() + ")";
    }
}

