/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.cardiac.common;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.LootEvent;
import it.hurts.octostudios.cardiac.common.entities.LifeOrb;
import it.hurts.octostudios.cardiac.common.init.ConfigRegistry;
import it.hurts.octostudios.cardiac.common.init.DispenserBehaviorRegistry;
import it.hurts.octostudios.cardiac.common.init.EnchantmentRegistry;
import it.hurts.octostudios.cardiac.common.init.EntityRegistry;
import it.hurts.octostudios.cardiac.common.init.ItemRegistry;
import it.hurts.octostudios.cardiac.common.init.SoundRegistry;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class Cardiac {
    public static final String MODID = "cardiac";

    public static void init() {
        EntityRegistry.registerCommon();
        SoundRegistry.registerCommon();
        ItemRegistry.registerCommon();
        EntityEvent.LIVING_DEATH.register((entity, source) -> {
            double toDrop;
            LivingEntity livingEntity;
            int enchantment;
            Entity killer = source.getEntity();
            if (!(killer instanceof Player) && ConfigRegistry.CONFIG.isShouldBeKilledByPlayer()) {
                return EventResult.pass();
            }
            Level level = entity.getCommandSenderWorld();
            RandomSource random = entity.getRandom();
            double basePercentage = 0.0;
            String entityId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).toString();
            for (Map.Entry<String, Double> entry : ConfigRegistry.CONFIG.getGeneralPercentages().entrySet()) {
                String pattern = entry.getKey();
                Double percentage = entry.getValue();
                try {
                    if (!entityId.matches(pattern)) continue;
                    basePercentage = percentage;
                }
                catch (PatternSyntaxException exception) {
                    if (!entityId.equals(pattern)) continue;
                    basePercentage = percentage;
                }
            }
            double lifestealPercentage = 0.0;
            if (killer instanceof LivingEntity && (enchantment = ((ItemEnchantments)(livingEntity = (LivingEntity)killer).getMainHandItem().getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).getLevel((Holder)level.holderLookup(Registries.ENCHANTMENT).getOrThrow(EnchantmentRegistry.LIFESTEAL))) > 0) {
                for (Map.Entry<String, Double> entry : ConfigRegistry.CONFIG.getLifestealPercentages().entrySet()) {
                    String pattern = entry.getKey();
                    Double percentage = entry.getValue();
                    try {
                        if (!entityId.matches(pattern)) continue;
                        lifestealPercentage = percentage;
                    }
                    catch (PatternSyntaxException exception) {
                        if (!entityId.equals(pattern)) continue;
                        lifestealPercentage = percentage;
                    }
                }
            }
            if ((toDrop = (double)entity.getMaxHealth() * (basePercentage + lifestealPercentage)) == 0.0) {
                return EventResult.pass();
            }
            int steps = ConfigRegistry.CONFIG.getMinOrbsAmount() + random.nextInt((int)Math.ceil(toDrop));
            for (int i = 0; i < steps; ++i) {
                LifeOrb orb = new LifeOrb((EntityType<? extends LifeOrb>)((EntityType)EntityRegistry.LIFE_ORB.get()), level);
                orb.setLife((float)(toDrop / (double)steps));
                orb.setPos(entity.position().add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0));
                orb.setDeltaMovement((-1.0f + 2.0f * random.nextFloat()) * 0.15f, 0.1f + random.nextFloat() * 0.3f, (-1.0f + 2.0f * random.nextFloat()) * 0.15f);
                level.addFreshEntity((Entity)orb);
            }
            return EventResult.pass();
        });
        LootEvent.MODIFY_LOOT_TABLE.register((key, context, builtin) -> {
            if (key.location().getPath().matches(".*chests.*")) {
                context.addPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.LIFE_BOTTLE.get())).setWeight(5).when(LootItemRandomChanceCondition.randomChance((float)0.2f))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))));
            }
        });
        LifecycleEvent.SETUP.register(() -> {
            DispenserBehaviorRegistry.registerCommon();
            ConfigRegistry.registerCommon();
        });
    }
}

