/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block.tile;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.DrawerBlock;
import com.buuz135.functionalstorage.block.tile.DrawerProperties;
import com.buuz135.functionalstorage.block.tile.StorageControllerTile;
import com.buuz135.functionalstorage.item.ConfigurationToolItem;
import com.buuz135.functionalstorage.item.FSAttachments;
import com.buuz135.functionalstorage.item.LinkingToolItem;
import com.buuz135.functionalstorage.item.UpgradeItem;
import com.buuz135.functionalstorage.item.component.FunctionalUpgradeBehavior;
import com.buuz135.functionalstorage.item.component.SizeProvider;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.client.screen.addon.TextScreenAddon;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.util.TileUtil;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public abstract class ControllableDrawerTile<T extends ControllableDrawerTile<T>>
extends ActiveTile<T> {
    private boolean needsUpgradeCache = true;
    @Save
    private BlockPos controllerPos;
    private InventoryComponent<ControllableDrawerTile<T>> storageUpgrades;
    @Save
    private InventoryComponent<ControllableDrawerTile<T>> utilityUpgrades;
    @Save
    private DrawerOptions drawerOptions = new DrawerOptions();
    @Save
    private boolean isCreative = false;
    @Save
    private boolean isVoid = false;
    @Save
    private boolean isStorageUpgradeLocked = false;
    public final Supplier<DataComponentType<SizeProvider>> sizeUpgradeComponent;
    @Save
    protected int baseSize;
    private float storageSize;
    private boolean isLocked;

    public ControllableDrawerTile(BasicTileBlock<T> base, BlockEntityType<T> entityType, BlockPos pos, BlockState state, DrawerProperties props) {
        super(base, entityType, pos, state);
        this.storageUpgrades = this.getStorageUpgradesConstructor();
        if (this.getStorageSlotAmount() > 0) {
            this.addInventory(this.storageUpgrades);
        }
        if (this.getUtilitySlotAmount() > 0) {
            this.utilityUpgrades = new InventoryComponent("utility_upgrades", 114, 70, this.getUtilitySlotAmount()).setInputFilter((stack, integer) -> {
                HolderSet incompatIn = (HolderSet)stack.get(FSAttachments.INCOMPATIBLE_UPGRADES);
                for (int i = 0; i < this.utilityUpgrades.getSlots(); ++i) {
                    ItemStack upgrade = this.utilityUpgrades.getStackInSlot(i);
                    HolderSet incompatOnUpgrade = (HolderSet)upgrade.get(FSAttachments.INCOMPATIBLE_UPGRADES);
                    if ((incompatIn == null || !upgrade.is(incompatIn)) && (incompatOnUpgrade == null || !stack.is(incompatOnUpgrade))) continue;
                    return false;
                }
                return stack.getItem() instanceof UpgradeItem && ((UpgradeItem)stack.getItem()).getType() == UpgradeItem.Type.UTILITY || stack.has(FSAttachments.FUNCTIONAL_BEHAVIOR);
            }).setSlotLimit(1).setOnSlotChanged((itemStack, integer) -> {
                BlockEntity patt0$temp;
                this.needsUpgradeCache = true;
                if (this.controllerPos != null && (patt0$temp = this.level.getBlockEntity(this.controllerPos)) instanceof StorageControllerTile) {
                    StorageControllerTile controllerTile = (StorageControllerTile)patt0$temp;
                    controllerTile.getConnectedDrawers().rebuild();
                }
            });
            this.addInventory(this.utilityUpgrades);
        }
        this.baseSize = props.baseSize();
        this.sizeUpgradeComponent = props.upgradeComponent();
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        if (compound.contains("storageUpgrades")) {
            this.storageUpgrades.deserializeNBT(provider, compound.getCompound("storageUpgrades"));
            this.recalculateUpgrades();
        }
        super.loadAdditional(compound, provider);
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        compoundTag.put("storageUpgrades", (Tag)this.storageUpgrades.serializeNBT(provider));
        super.saveAdditional(compoundTag, provider);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        if (this.getStorageSlotAmount() > 0) {
            this.addGuiAddonFactory(() -> new TextScreenAddon(this, "gui.functionalstorage.storage", 10, 59, false, ChatFormatting.DARK_GRAY.getColor()){

                public String getText() {
                    return Component.translatable((String)"key.categories.storage").getString();
                }
            });
        }
        if (this.getUtilitySlotAmount() > 0) {
            this.addGuiAddonFactory(() -> new TextScreenAddon(this, "gui.functionalstorage.utility", 114, 59, false, ChatFormatting.DARK_GRAY.getColor()){

                public String getText() {
                    return Component.translatable((String)"key.categories.utility").getString();
                }
            });
        }
        this.addGuiAddonFactory(() -> new TextScreenAddon(this, "key.categories.inventory", 8, 92, false, ChatFormatting.DARK_GRAY.getColor()){

            public String getText() {
                return Component.translatable((String)"key.categories.inventory").getString();
            }
        });
    }

    public Direction getFacingDirection() {
        return this.level.getBlockState(this.worldPosition).hasProperty((Property)DrawerBlock.FACING_HORIZONTAL_CUSTOM) ? (Direction)this.level.getBlockState(this.worldPosition).getValue((Property)DrawerBlock.FACING_HORIZONTAL_CUSTOM) : (this.level.getBlockState(this.worldPosition).hasProperty((Property)RotatableBlock.FACING_HORIZONTAL) ? (Direction)this.level.getBlockState(this.worldPosition).getValue((Property)RotatableBlock.FACING_HORIZONTAL) : Direction.NORTH);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
        if (this.getUtilitySlotAmount() > 0) {
            for (int i = 0; i < this.utilityUpgrades.getSlots(); ++i) {
                FunctionalUpgradeBehavior comp;
                ItemStack stack = this.utilityUpgrades.getStackInSlot(i);
                if (stack.isEmpty() || (comp = (FunctionalUpgradeBehavior)stack.get(FSAttachments.FUNCTIONAL_BEHAVIOR)) == null) continue;
                comp.work(this.level, this.getBlockPos(), this, stack, i);
            }
        }
    }

    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    public void setControllerPos(BlockPos controllerPos) {
        if (this.controllerPos != null) {
            TileUtil.getTileEntity((BlockGetter)this.getLevel(), (BlockPos)this.controllerPos, StorageControllerTile.class).ifPresent(drawerControllerTile -> drawerControllerTile.addConnectedDrawers(LinkingToolItem.ActionMode.REMOVE, this.getBlockPos()));
        }
        this.controllerPos = controllerPos;
    }

    public void clearControllerPos() {
        this.controllerPos = null;
    }

    public float getStorageMultiplier() {
        this.maybeCacheUpgrades();
        return this.storageSize;
    }

    public boolean isVoid() {
        this.maybeCacheUpgrades();
        return this.isVoid;
    }

    public boolean isCreative() {
        this.maybeCacheUpgrades();
        return this.isCreative;
    }

    public void setNeedsUpgradeCache(boolean needsUpgradeCache) {
        this.needsUpgradeCache = needsUpgradeCache;
    }

    public InteractionResult onSlotActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ, int slot) {
        UpgradeItem ui;
        InventoryComponent<ControllableDrawerTile<T>> component2;
        ItemStack stack = playerIn.getItemInHand(hand);
        if (stack.getItem().equals(FunctionalStorage.CONFIGURATION_TOOL.get()) || stack.getItem().equals(FunctionalStorage.LINKING_TOOL.get())) {
            return InteractionResult.PASS;
        }
        SizeProvider sizeComp = (SizeProvider)stack.get(this.sizeUpgradeComponent);
        FunctionalUpgradeBehavior funcComp = (FunctionalUpgradeBehavior)stack.get(FSAttachments.FUNCTIONAL_BEHAVIOR);
        if (sizeComp != null || stack.is((Item)FunctionalStorage.CREATIVE_UPGRADE.get())) {
            int i;
            InventoryComponent<ControllableDrawerTile<T>> component2 = this.storageUpgrades;
            for (i = 0; i < component2.getSlots(); ++i) {
                if (!component2.getStackInSlot(i).isEmpty() || !component2.isItemValid(i, stack)) continue;
                playerIn.setItemInHand(hand, component2.insertItem(i, stack, false));
                return InteractionResult.SUCCESS;
            }
            if (sizeComp != null) {
                for (i = 0; i < component2.getSlots(); ++i) {
                    if (component2.getStackInSlot(i).isEmpty() || !component2.isItemValid(i, stack) || !component2.getStackInSlot(i).has(this.sizeUpgradeComponent) || !(((SizeProvider)component2.getStackInSlot(i).get(this.sizeUpgradeComponent)).applyFactorModifier(1.0f) < sizeComp.applyFactorModifier(1.0f))) continue;
                    ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)component2.getStackInSlot(i).copy());
                    ItemStack upgradeStack = stack.copy();
                    upgradeStack.setCount(1);
                    component2.setStackInSlot(i, upgradeStack);
                    stack.shrink(1);
                    return InteractionResult.SUCCESS;
                }
            }
        } else if (funcComp != null || (component2 = stack.getItem()) instanceof UpgradeItem && (ui = (UpgradeItem)component2).getType() == UpgradeItem.Type.UTILITY) {
            component2 = this.utilityUpgrades;
            for (int i = 0; i < component2.getSlots(); ++i) {
                if (!component2.getStackInSlot(i).isEmpty() || !component2.isItemValid(i, stack)) continue;
                playerIn.setItemInHand(hand, component2.insertItem(i, stack, false));
                return InteractionResult.SUCCESS;
            }
        }
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ) == ItemInteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        if (slot == -1) {
            this.openGui(playerIn);
        }
        return InteractionResult.SUCCESS;
    }

    public abstract int getStorageSlotAmount();

    public int getUtilitySlotAmount() {
        return 3;
    }

    public void onClicked(Player playerIn, int slot) {
    }

    private void maybeCacheUpgrades() {
        if (this.needsUpgradeCache) {
            this.recalculateUpgrades();
            this.needsUpgradeCache = false;
        }
    }

    public void recalculateUpgrades() {
        int i;
        this.isCreative = false;
        this.storageSize = SizeProvider.calculateAsFactor(this.storageUpgrades, this.sizeUpgradeComponent, this.baseSize);
        for (i = 0; i < this.storageUpgrades.getSlots(); ++i) {
            Item upgrade = this.storageUpgrades.getStackInSlot(i).getItem();
            if (!upgrade.equals(FunctionalStorage.CREATIVE_UPGRADE.get())) continue;
            this.isCreative = true;
        }
        this.isVoid = false;
        if (this.getUtilitySlotAmount() > 0) {
            for (i = 0; i < this.utilityUpgrades.getSlots(); ++i) {
                if (!this.utilityUpgrades.getStackInSlot(i).getItem().equals(FunctionalStorage.VOID_UPGRADE.get())) continue;
                this.isVoid = true;
            }
        }
        this.isLocked = this.getBlockState().hasProperty((Property)DrawerBlock.LOCKED) && (Boolean)this.getBlockState().getValue((Property)DrawerBlock.LOCKED) != false;
    }

    public void toggleLocking() {
        this.setLocked(!this.isLocked());
    }

    public boolean isLocked() {
        this.maybeCacheUpgrades();
        return this.isLocked;
    }

    public void setLocked(boolean locked) {
        if (this.getBlockState().hasProperty((Property)DrawerBlock.LOCKED)) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)DrawerBlock.LOCKED, (Comparable)Boolean.valueOf(locked)), 3);
            this.setNeedsUpgradeCache(true);
        }
    }

    public void toggleOption(ConfigurationToolItem.ConfigurationAction action) {
        if (action.getMax() == 1) {
            this.drawerOptions.setActive(action, !this.drawerOptions.isActive(action));
        } else {
            this.drawerOptions.setAdvancedValue(action, (this.drawerOptions.getAdvancedValue(action) + 1) % (action.getMax() + 1));
        }
        this.markForUpdate();
    }

    public DrawerOptions getDrawerOptions() {
        return this.drawerOptions;
    }

    public InventoryComponent<ControllableDrawerTile<T>> getUtilityUpgrades() {
        return this.utilityUpgrades;
    }

    public InventoryComponent<ControllableDrawerTile<T>> getStorageUpgrades() {
        return this.storageUpgrades;
    }

    public boolean isEverythingEmpty() {
        int i;
        for (i = 0; i < this.getStorageUpgrades().getSlots(); ++i) {
            if (this.getStorageUpgrades().getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        for (i = 0; i < this.getUtilityUpgrades().getSlots(); ++i) {
            if (this.getUtilityUpgrades().getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public abstract InventoryComponent<ControllableDrawerTile<T>> getStorageUpgradesConstructor();

    public int getTitleColor() {
        return ChatFormatting.DARK_GRAY.getColor();
    }

    public boolean isStorageUpgradeLocked() {
        return this.isStorageUpgradeLocked;
    }

    public static class DrawerOptions
    implements INBTSerializable<CompoundTag> {
        public HashMap<ConfigurationToolItem.ConfigurationAction, Boolean> options = new HashMap();
        public HashMap<ConfigurationToolItem.ConfigurationAction, Integer> advancedOptions;

        public DrawerOptions() {
            this.options.put(ConfigurationToolItem.ConfigurationAction.TOGGLE_NUMBERS, true);
            this.options.put(ConfigurationToolItem.ConfigurationAction.TOGGLE_RENDER, true);
            this.options.put(ConfigurationToolItem.ConfigurationAction.TOGGLE_UPGRADES, true);
            this.advancedOptions = new HashMap();
            this.advancedOptions.put(ConfigurationToolItem.ConfigurationAction.INDICATOR, 0);
        }

        public boolean isActive(ConfigurationToolItem.ConfigurationAction configurationAction) {
            return this.options.getOrDefault((Object)configurationAction, true);
        }

        public void setActive(ConfigurationToolItem.ConfigurationAction configurationAction, boolean active) {
            this.options.put(configurationAction, active);
        }

        public int getAdvancedValue(ConfigurationToolItem.ConfigurationAction configurationAction) {
            return this.advancedOptions.getOrDefault((Object)configurationAction, 0);
        }

        public void setAdvancedValue(ConfigurationToolItem.ConfigurationAction configurationAction, int value) {
            this.advancedOptions.put(configurationAction, value);
        }

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            CompoundTag compoundTag = new CompoundTag();
            for (ConfigurationToolItem.ConfigurationAction action : this.options.keySet()) {
                compoundTag.putBoolean(action.name(), this.options.get((Object)action).booleanValue());
            }
            for (ConfigurationToolItem.ConfigurationAction action : this.advancedOptions.keySet()) {
                compoundTag.putInt("Advanced: " + action.name(), this.advancedOptions.get((Object)action).intValue());
            }
            return compoundTag;
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
            for (String allKey : nbt.getAllKeys()) {
                if (allKey.startsWith("Advanced: ")) {
                    this.advancedOptions.put(ConfigurationToolItem.ConfigurationAction.valueOf(allKey.replace("Advanced: ", "")), nbt.getInt(allKey));
                    continue;
                }
                this.options.put(ConfigurationToolItem.ConfigurationAction.valueOf(allKey), nbt.getBoolean(allKey));
            }
        }
    }
}

