/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.cloudglass.datagen.server;

import com.mrbysco.cloudglass.block.CloudGlassBlock;
import com.mrbysco.cloudglass.registry.CloudRegistry;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredBlock;

public class CloudRecipeProvider
extends RecipeProvider {
    public CloudRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(output, lookupProvider);
    }

    protected void buildRecipes(RecipeOutput output) {
        this.cloudRecipe(CloudRegistry.WHITE_CLOUD_GLASS, (ItemLike)Blocks.WHITE_WOOL, output);
        this.cloudRecipe(CloudRegistry.ORANGE_CLOUD_GLASS, (ItemLike)Blocks.ORANGE_WOOL, output);
        this.cloudRecipe(CloudRegistry.MAGENTA_CLOUD_GLASS, (ItemLike)Blocks.MAGENTA_WOOL, output);
        this.cloudRecipe(CloudRegistry.LIGHT_BLUE_CLOUD_GLASS, (ItemLike)Blocks.LIGHT_BLUE_WOOL, output);
        this.cloudRecipe(CloudRegistry.YELLOW_CLOUD_GLASS, (ItemLike)Blocks.YELLOW_WOOL, output);
        this.cloudRecipe(CloudRegistry.LIME_CLOUD_GLASS, (ItemLike)Blocks.LIME_WOOL, output);
        this.cloudRecipe(CloudRegistry.PINK_CLOUD_GLASS, (ItemLike)Blocks.PINK_WOOL, output);
        this.cloudRecipe(CloudRegistry.GRAY_CLOUD_GLASS, (ItemLike)Blocks.GRAY_WOOL, output);
        this.cloudRecipe(CloudRegistry.LIGHT_GRAY_CLOUD_GLASS, (ItemLike)Blocks.LIGHT_GRAY_WOOL, output);
        this.cloudRecipe(CloudRegistry.CYAN_CLOUD_GLASS, (ItemLike)Blocks.CYAN_WOOL, output);
        this.cloudRecipe(CloudRegistry.PURPLE_CLOUD_GLASS, (ItemLike)Blocks.PURPLE_WOOL, output);
        this.cloudRecipe(CloudRegistry.BLUE_CLOUD_GLASS, (ItemLike)Blocks.BLUE_WOOL, output);
        this.cloudRecipe(CloudRegistry.BROWN_CLOUD_GLASS, (ItemLike)Blocks.BROWN_WOOL, output);
        this.cloudRecipe(CloudRegistry.GREEN_CLOUD_GLASS, (ItemLike)Blocks.GREEN_WOOL, output);
        this.cloudRecipe(CloudRegistry.RED_CLOUD_GLASS, (ItemLike)Blocks.RED_WOOL, output);
        this.cloudRecipe(CloudRegistry.BLACK_CLOUD_GLASS, (ItemLike)Blocks.BLACK_WOOL, output);
        this.dyeRecipe(CloudRegistry.ORANGE_CLOUD_GLASS, (TagKey<Item>)Tags.Items.DYES_ORANGE, output);
        this.dyeRecipe(CloudRegistry.MAGENTA_CLOUD_GLASS, (TagKey<Item>)Tags.Items.DYES_MAGENTA, output);
        this.dyeRecipe(CloudRegistry.LIGHT_BLUE_CLOUD_GLASS, (TagKey<Item>)Tags.Items.DYES_LIGHT_BLUE, output);
        this.dyeRecipe(CloudRegistry.YELLOW_CLOUD_GLASS, (TagKey<Item>)Tags.Items.DYES_YELLOW, output);
        this.dyeRecipe(CloudRegistry.LIME_CLOUD_GLASS, (TagKey<Item>)Tags.Items.DYES_LIME, output);
        this.dyeRecipe(CloudRegistry.PINK_CLOUD_GLASS, (TagKey<Item>)Tags.Items.DYES_PINK, output);
        this.dyeRecipe(CloudRegistry.GRAY_CLOUD_GLASS, (TagKey<Item>)Tags.Items.DYES_GRAY, output);
        this.dyeRecipe(CloudRegistry.LIGHT_GRAY_CLOUD_GLASS, (TagKey<Item>)Tags.Items.DYES_LIGHT_GRAY, output);
        this.dyeRecipe(CloudRegistry.CYAN_CLOUD_GLASS, (TagKey<Item>)Tags.Items.DYES_CYAN, output);
        this.dyeRecipe(CloudRegistry.PURPLE_CLOUD_GLASS, (TagKey<Item>)Tags.Items.DYES_PURPLE, output);
        this.dyeRecipe(CloudRegistry.BLUE_CLOUD_GLASS, (TagKey<Item>)Tags.Items.DYES_BLUE, output);
        this.dyeRecipe(CloudRegistry.BROWN_CLOUD_GLASS, (TagKey<Item>)Tags.Items.DYES_BROWN, output);
        this.dyeRecipe(CloudRegistry.GREEN_CLOUD_GLASS, (TagKey<Item>)Tags.Items.DYES_GREEN, output);
        this.dyeRecipe(CloudRegistry.RED_CLOUD_GLASS, (TagKey<Item>)Tags.Items.DYES_RED, output);
        this.dyeRecipe(CloudRegistry.BLACK_CLOUD_GLASS, (TagKey<Item>)Tags.Items.DYES_BLACK, output);
    }

    private void cloudRecipe(DeferredBlock<CloudGlassBlock> block, ItemLike wool, RecipeOutput output) {
        new ShapedRecipeBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)block.asItem(), 4).pattern(" W ").pattern("WGW").pattern(" W ").define(Character.valueOf('W'), wool).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS_COLORLESS).unlockedBy("has_wool", CloudRecipeProvider.has((ItemLike)wool)).unlockedBy("has_glass", CloudRecipeProvider.has((TagKey)Tags.Items.GLASS_BLOCKS_COLORLESS)).save(output);
    }

    private void dyeRecipe(DeferredBlock<CloudGlassBlock> block, TagKey<Item> dye, RecipeOutput output) {
        new ShapedRecipeBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)block.asItem(), 8).pattern("CCC").pattern("CDC").pattern("CCC").define(Character.valueOf('C'), CloudRegistry.WHITE_CLOUD_GLASS).define(Character.valueOf('D'), dye).unlockedBy("has_cloud", CloudRecipeProvider.has(CloudRegistry.WHITE_CLOUD_GLASS)).unlockedBy("has_dye", CloudRecipeProvider.has(dye)).save(output, block.getId().withSuffix("_from_dye"));
    }
}

