/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.registry;

import de.ellpeck.prettypipes.items.ModuleItem;
import de.ellpeck.prettypipes.items.ModuleTier;
import de.ellpeck.prettypipes.pipe.IPipeItem;
import dev.quarris.ppfluids.item.FluidExtractionModuleItem;
import dev.quarris.ppfluids.item.FluidFilterModuleItem;
import dev.quarris.ppfluids.item.FluidItem;
import dev.quarris.ppfluids.item.FluidLimiterModuleItem;
import dev.quarris.ppfluids.item.FluidRetrievalModuleItem;
import dev.quarris.ppfluids.pipenetwork.FluidPipeItem;
import dev.quarris.ppfluids.registry.BlockSetup;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.commons.lang3.function.TriFunction;

public class ItemSetup {
    public static final DeferredRegister.Items REGISTRY = DeferredRegister.Items.createItems((String)"ppfluids");
    public static final Supplier<FluidItem> FLUID_HOLDER = REGISTRY.register("fluid_item", FluidItem::new);
    public static final DeferredItem<FluidLimiterModuleItem> LIMITER_MODULE = REGISTRY.registerItem("fluid_limiter_module", props -> new FluidLimiterModuleItem("fluid_limiter_module", (Item.Properties)props), new Item.Properties());
    public static final Map<ModuleTier, DeferredItem<ModuleItem>> EXTRACTION_MODULES = new EnumMap<ModuleTier, DeferredItem<ModuleItem>>(ModuleTier.class);
    public static final Map<ModuleTier, DeferredItem<ModuleItem>> FILTER_MODULES = new EnumMap<ModuleTier, DeferredItem<ModuleItem>>(ModuleTier.class);
    public static final Map<ModuleTier, DeferredItem<ModuleItem>> RETRIEVAL_MODULES = new EnumMap<ModuleTier, DeferredItem<ModuleItem>>(ModuleTier.class);

    public static void init(IEventBus bus) {
        REGISTRY.register(bus);
    }

    private static void registerTieredModule(Map<ModuleTier, DeferredItem<ModuleItem>> registryMap, String name, Item.Properties properties, TriFunction<String, ModuleTier, Item.Properties, ModuleItem> item) {
        for (ModuleTier tier : ModuleTier.values()) {
            String moduleName = tier.name().toLowerCase(Locale.ROOT) + "_" + name;
            DeferredItem module = REGISTRY.registerItem(moduleName, props -> (ModuleItem)item.apply((Object)name, (Object)tier, props), properties);
            registryMap.put(tier, (DeferredItem<ModuleItem>)module);
        }
    }

    static {
        REGISTRY.registerSimpleBlockItem(BlockSetup.FLUID_PIPE);
        ItemSetup.registerTieredModule(EXTRACTION_MODULES, "fluid_extraction_module", new Item.Properties(), (TriFunction<String, ModuleTier, Item.Properties, ModuleItem>)((TriFunction)FluidExtractionModuleItem::new));
        ItemSetup.registerTieredModule(FILTER_MODULES, "fluid_filter_module", new Item.Properties(), (TriFunction<String, ModuleTier, Item.Properties, ModuleItem>)((TriFunction)FluidFilterModuleItem::new));
        ItemSetup.registerTieredModule(RETRIEVAL_MODULES, "fluid_retrieval_module", new Item.Properties(), (TriFunction<String, ModuleTier, Item.Properties, ModuleItem>)((TriFunction)FluidRetrievalModuleItem::new));
        IPipeItem.TYPES.put(FluidPipeItem.FLUID_TYPE, FluidPipeItem::new);
    }
}

