/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.pipe;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.pipe.ConnectionType;
import de.ellpeck.prettypipes.pipe.IPipeConnectable;
import de.ellpeck.prettypipes.pipe.PipeBlock;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import dev.quarris.ppfluids.pipe.FluidPipeBlockEntity;
import dev.quarris.ppfluids.registry.BlockEntitySetup;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.jetbrains.annotations.Nullable;

public class FluidPipeBlock
extends PipeBlock {
    public FluidPipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FluidPipeBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return FluidPipeBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)BlockEntitySetup.FLUID_PIPE.get()), PipeBlockEntity::tick);
    }

    protected ConnectionType getConnectionType(Level level, BlockPos pos, Direction direction, BlockState state) {
        BlockState offState;
        BlockPos offset = pos.relative(direction);
        if (!level.isLoaded(offset)) {
            return ConnectionType.DISCONNECTED;
        }
        Direction opposite = direction.getOpposite();
        BlockEntity tile = level.getBlockEntity(offset);
        if (tile != null) {
            IPipeConnectable connectable = (IPipeConnectable)level.getCapability(Registry.pipeConnectableCapability, offset, (Object)opposite);
            if (connectable != null) {
                return connectable.getConnectionType(pos, direction);
            }
            if (level.getCapability(Capabilities.FluidHandler.BLOCK, offset, (Object)opposite) != null) {
                return ConnectionType.CONNECTED;
            }
        }
        if (FluidPipeBlock.hasLegsTo((Level)level, (BlockState)(offState = level.getBlockState(offset)), (BlockPos)offset, (Direction)direction) && DIRECTIONS.values().stream().noneMatch(d -> state.getValue((Property)d) == ConnectionType.LEGS)) {
            return ConnectionType.LEGS;
        }
        return ConnectionType.DISCONNECTED;
    }
}

