/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.network;

import de.ellpeck.prettypipes.pipe.containers.AbstractPipeContainer;
import dev.quarris.ppfluids.ModRef;
import dev.quarris.ppfluids.item.FluidLimiterModuleItem;
import dev.quarris.ppfluids.misc.FluidFilter;
import dev.quarris.ppfluids.registry.DataComponentSetup;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.logging.log4j.util.TriConsumer;

public record FluidButtonPayload(BlockPos pos, int result, List<Integer> data) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<FluidButtonPayload> TYPE = new CustomPacketPayload.Type(ModRef.res("fluid_button"));
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidButtonPayload> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, FluidButtonPayload::pos, (StreamCodec)ByteBufCodecs.INT, FluidButtonPayload::result, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.INT), FluidButtonPayload::data, FluidButtonPayload::new);

    public FluidButtonPayload(BlockPos pos, ButtonResult result, List<Integer> data) {
        this(pos, result.ordinal(), data);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void onMessage(FluidButtonPayload message, IPayloadContext ctx) {
        Player player = ctx.player();
        ButtonResult.values()[message.result].action.accept((Object)message.pos, message.data, (Object)player);
    }

    public static void sendAndExecute(BlockPos pos, ButtonResult result, int ... data) {
        ArrayList<Integer> dataList = new ArrayList<Integer>();
        for (int d : data) {
            dataList.add(d);
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new FluidButtonPayload(pos, result, dataList), (CustomPacketPayload[])new CustomPacketPayload[0]);
        result.action.accept((Object)pos, dataList, (Object)Minecraft.getInstance().player);
    }

    public static enum ButtonResult {
        FILTER_CHANGE((TriConsumer<BlockPos, List<Integer>, Player>)((TriConsumer)(pos, data, player) -> {
            FluidFilter.IFluidFilteredContainer container = (FluidFilter.IFluidFilteredContainer)player.containerMenu;
            FluidFilter filter = container.getFilter();
            filter.onButtonPacket(container, (Integer)data.get(0));
        })),
        LIMITER_MEASURE((TriConsumer<BlockPos, List<Integer>, Player>)((TriConsumer)(pos, data, player) -> {
            AbstractPipeContainer container = (AbstractPipeContainer)player.containerMenu;
            FluidLimiterModuleItem.LimiterData moduleData = (FluidLimiterModuleItem.LimiterData)container.moduleStack.getOrDefault(DataComponentSetup.FLUID_LIMITER, (Object)FluidLimiterModuleItem.LimiterData.DEFAULT);
            container.moduleStack.set(DataComponentSetup.FLUID_LIMITER, (Object)new FluidLimiterModuleItem.LimiterData(moduleData.maxAmount(), !moduleData.useBucketMeasure()));
        })),
        LIMITER_AMOUNT((TriConsumer<BlockPos, List<Integer>, Player>)((TriConsumer)(pos, data, player) -> {
            AbstractPipeContainer container = (AbstractPipeContainer)player.containerMenu;
            FluidLimiterModuleItem.LimiterData moduleData = (FluidLimiterModuleItem.LimiterData)container.moduleStack.getOrDefault(DataComponentSetup.FLUID_LIMITER, (Object)FluidLimiterModuleItem.LimiterData.DEFAULT);
            container.moduleStack.set(DataComponentSetup.FLUID_LIMITER, (Object)new FluidLimiterModuleItem.LimiterData((Integer)data.getFirst(), moduleData.useBucketMeasure()));
        }));

        public final TriConsumer<BlockPos, List<Integer>, Player> action;

        private ButtonResult(TriConsumer<BlockPos, List<Integer>, Player> action) {
            this.action = action;
        }
    }
}

