/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.misc;

import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.misc.DirectionSelector;
import de.ellpeck.prettypipes.packets.PacketButton;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import dev.quarris.ppfluids.mixins.DirectionSelectorAccessor;
import dev.quarris.ppfluids.pipe.FluidPipeBlockEntity;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;

public class FluidDirectionSelector
extends DirectionSelector {
    public FluidDirectionSelector(ItemStack stack, PipeBlockEntity pipe) {
        super(stack, pipe);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AbstractWidget getButton(int x, int y) {
        final DirectionSelectorAccessor accessor = (DirectionSelectorAccessor)((Object)this);
        return new ExtendedButton(this, x, y, 100, 20, (Component)Component.translatable((String)"info.prettypipes.populate"), button -> PacketButton.sendAndExecute((BlockPos)accessor.getPipe().getBlockPos(), (PacketButton.ButtonResult)PacketButton.ButtonResult.DIRECTION_SELECTOR, List.of())){

            public Component getMessage() {
                PipeBlockEntity pipe = accessor.getPipe();
                Direction dir = accessor.getDirection();
                MutableComponent msg = Component.translatable((String)("dir.prettypipes." + (dir != null ? dir.getName() : "all")));
                if (dir != null && pipe instanceof FluidPipeBlockEntity) {
                    MutableComponent blockName;
                    FluidPipeBlockEntity fluidPipe = (FluidPipeBlockEntity)pipe;
                    MutableComponent mutableComponent = blockName = fluidPipe.getFluidHandler(dir) != null ? pipe.getLevel().getBlockState(pipe.getBlockPos().relative(dir)).getBlock().getName() : null;
                    if (blockName != null) {
                        msg = msg.append(" (").append((Component)blockName).append(")");
                    }
                }
                return msg;
            }
        };
    }

    public static boolean isDirectionValid(DirectionSelectorAccessor selector, Direction dir) {
        PipeBlockEntity pipeBlockEntity = selector.getPipe();
        if (!(pipeBlockEntity instanceof FluidPipeBlockEntity)) {
            return false;
        }
        FluidPipeBlockEntity fluidPipe = (FluidPipeBlockEntity)pipeBlockEntity;
        if (dir == null) {
            return true;
        }
        if (fluidPipe.getFluidHandler(dir) == null) {
            return false;
        }
        return fluidPipe.streamModules().filter(p -> p.getLeft() != selector.getStack()).map(p -> (DirectionSelectorAccessor)((IModule)p.getRight()).getDirectionSelector((ItemStack)p.getLeft(), (PipeBlockEntity)fluidPipe)).noneMatch(p -> p != null && p.getDirection() == dir);
    }
}

