/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeContainer;
import dev.quarris.ppfluids.container.FluidLimiterContainer;
import dev.quarris.ppfluids.item.FluidModuleItem;
import dev.quarris.ppfluids.registry.DataComponentSetup;
import dev.quarris.ppfluids.registry.MenuSetup;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidLimiterModuleItem
extends FluidModuleItem {
    public FluidLimiterModuleItem(String name, Item.Properties properties) {
        super(name, properties);
    }

    @Override
    public int getMaxInsertionAmount(ItemStack module, PipeBlockEntity pipe, FluidStack fluid, IFluidHandler destination) {
        LimiterData data = (LimiterData)module.getOrDefault(DataComponentSetup.FLUID_LIMITER, (Object)LimiterData.DEFAULT);
        int max = data.maxAmount;
        if (data.useBucketMeasure) {
            max *= 1000;
        }
        int storedAmount = 0;
        for (int i = 0; i < destination.getTanks(); ++i) {
            FluidStack storedFluid = destination.getFluidInTank(i);
            if (storedFluid.isEmpty() || (storedAmount += storedFluid.getAmount()) < max) continue;
            return 0;
        }
        return max - storedAmount;
    }

    @Override
    public boolean isCompatible(ItemStack itemStack, PipeBlockEntity pipeBlockEntity, IModule iModule) {
        return !(iModule instanceof FluidLimiterModuleItem);
    }

    @Override
    public boolean hasContainer(ItemStack itemStack, PipeBlockEntity pipeBlockEntity) {
        return true;
    }

    public AbstractPipeContainer<?> getContainer(ItemStack module, PipeBlockEntity tile, int windowId, Inventory inv, Player player, int moduleIndex) {
        return new FluidLimiterContainer((MenuType)MenuSetup.FLUID_LIMITER.get(), windowId, player, tile.getBlockPos(), moduleIndex);
    }

    public record LimiterData(int maxAmount, boolean useBucketMeasure) {
        public static final LimiterData DEFAULT = new LimiterData(8000, false);
        public static final Codec<LimiterData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.fieldOf("max_amount").forGetter(LimiterData::maxAmount), (App)Codec.BOOL.fieldOf("use_bucket_measure").forGetter(LimiterData::useBucketMeasure)).apply((Applicative)i, LimiterData::new));
    }
}

