/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.item;

import dev.quarris.ppfluids.registry.ItemSetup;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidItem
extends Item {
    public FluidItem() {
        super(new Item.Properties());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"info.ppfluids.fluid_item.usage"));
        FluidStack fluidStack = FluidItem.getFluidCopyFromItem(stack);
        tooltip.add((Component)fluidStack.getHoverName().copy().append(": ").append(String.valueOf(fluidStack.getAmount())));
    }

    public static ItemStack createItemFromFluid(FluidStack fluid) {
        ItemStack item = new ItemStack((ItemLike)ItemSetup.FLUID_HOLDER.get());
        FluidUtil.getFluidHandler((ItemStack)item).ifPresent(tank -> tank.fill(fluid, IFluidHandler.FluidAction.EXECUTE));
        return item;
    }

    public static FluidStack getFluidCopyFromItem(ItemStack item) {
        return FluidUtil.getFluidHandler((ItemStack)item).map(handler -> handler.getFluidInTank(0)).orElse(FluidStack.EMPTY).copy();
    }

    public static ItemStack insertFluid(IFluidHandler handler, ItemStack fluidItem) {
        FluidStack fluidStack = FluidItem.getFluidCopyFromItem(fluidItem);
        int filled = handler.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE);
        if (filled <= 0) {
            return fluidItem;
        }
        filled = handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
        fluidStack.shrink(filled);
        if (fluidStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return FluidItem.createItemFromFluid(fluidStack);
    }
}

