/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.client.screen;

import de.ellpeck.prettypipes.pipe.containers.AbstractPipeContainer;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeGui;
import dev.quarris.ppfluids.container.FluidLimiterContainer;
import dev.quarris.ppfluids.item.FluidLimiterModuleItem;
import dev.quarris.ppfluids.network.FluidButtonPayload;
import dev.quarris.ppfluids.registry.DataComponentSetup;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class FluidLimiterScreen
extends AbstractPipeGui<FluidLimiterContainer> {
    public FluidLimiterScreen(FluidLimiterContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractPipeContainer)screenContainer, inv, titleIn);
    }

    protected void init() {
        super.init();
        1 textField = this.addRenderableWidget((GuiEventListener)new EditBox(this, this.font, this.leftPos + 7, this.topPos + 17 + 32 + 10, 100, 20, (Component)Component.translatable((String)"info.ppfluids.max_stack_size")){

            public void insertText(String textToWrite) {
                StringBuilder ret = new StringBuilder();
                for (char c : textToWrite.toCharArray()) {
                    if (!Character.isDigit(c)) continue;
                    ret.append(c);
                }
                super.insertText(ret.toString());
            }
        });
        FluidLimiterModuleItem.LimiterData data = (FluidLimiterModuleItem.LimiterData)((FluidLimiterContainer)this.menu).moduleStack.getOrDefault(DataComponentSetup.FLUID_LIMITER, (Object)FluidLimiterModuleItem.LimiterData.DEFAULT);
        textField.setValue(String.valueOf(data.maxAmount()));
        textField.setMaxLength(10);
        textField.setResponder(s -> {
            if (s.isEmpty()) {
                return;
            }
            int amount = Integer.parseInt(s);
            FluidButtonPayload.sendAndExecute(((FluidLimiterContainer)this.menu).tile.getBlockPos(), FluidButtonPayload.ButtonResult.LIMITER_AMOUNT, amount);
        });
        Function<FluidLimiterModuleItem.LimiterData, Component> buttonText = d -> Component.literal((String)(d.useBucketMeasure() ? "B" : "mB"));
        Function<FluidLimiterModuleItem.LimiterData, Component> buttonTooltip = d -> Component.translatable((String)("info.ppfluids.limit_buckets_" + (d.useBucketMeasure() ? "on" : "off")));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)buttonText.apply(data), b -> {
            FluidButtonPayload.sendAndExecute(((FluidLimiterContainer)this.menu).tile.getBlockPos(), FluidButtonPayload.ButtonResult.LIMITER_MEASURE, new int[0]);
            FluidLimiterModuleItem.LimiterData limiterData = (FluidLimiterModuleItem.LimiterData)((FluidLimiterContainer)this.menu).moduleStack.getOrDefault(DataComponentSetup.FLUID_LIMITER, (Object)FluidLimiterModuleItem.LimiterData.DEFAULT);
            b.setMessage((Component)buttonText.apply(limiterData));
            b.setTooltip(Tooltip.create((Component)((Component)buttonTooltip.apply(limiterData))));
        }).tooltip(Tooltip.create((Component)buttonTooltip.apply(data))).bounds(this.leftPos + 7 + 100 + 4, this.topPos + 17 + 32 + 10, 20, 20).build());
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        graphics.drawString(this.font, (Component)Component.translatable((String)"info.ppfluids.limited_amount"), 7, 49, 0x404040, false);
    }
}

