/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.quarris.ppfluids.pipenetwork.FluidPipeItem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidBlobRenderer {
    private static final FluidBlobModel MODEL = new FluidBlobModel(FluidBlobModel.createBlobLayer().bakeRoot());

    public static void render(FluidPipeItem item, PoseStack matrix, Random random, float partialTicks, int light, int overlay, MultiBufferSource buffer) {
        long time = item.getTicksExisted();
        float lastSizeOffset = (float)(Math.sin(Math.toRadians((time - 1L) * 10L)) + 1.0) / 30.0f;
        float thisSizeOffset = (float)(Math.sin(Math.toRadians(time * 10L)) + 1.0) / 30.0f;
        float sizeOffset = Mth.lerp((float)partialTicks, (float)lastSizeOffset, (float)thisSizeOffset);
        FluidStack fluidStack = item.getFluidContent();
        Fluid fluid = fluidStack.getFluid();
        FluidState renderState = fluid.defaultFluidState();
        IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((FluidState)renderState);
        float size = Mth.lerp((float)Math.min(1.0f, (float)fluidStack.getAmount() / 2000.0f), (float)(0.1f - sizeOffset), (float)(0.25f + sizeOffset));
        int color = attributes.getTintColor(renderState, (BlockAndTintGetter)Minecraft.getInstance().level, item.getCurrentPipe());
        float tx = Mth.lerp((float)partialTicks, (float)item.lastX, (float)item.x);
        float ty = Mth.lerp((float)partialTicks, (float)item.lastY, (float)item.y);
        float tz = Mth.lerp((float)partialTicks, (float)item.lastZ, (float)item.z);
        TextureAtlasSprite sprite = FluidBlobRenderer.getFluidStillSprite(fluid);
        VertexConsumer vbuf = sprite.wrap(buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)sprite.atlasLocation())));
        matrix.pushPose();
        matrix.translate(tx, ty, tz);
        matrix.scale(size, size, size);
        MODEL.renderToBuffer(matrix, vbuf, light, overlay, color);
        matrix.popPose();
    }

    private static TextureAtlasSprite getFluidStillSprite(Fluid fluid) {
        IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)fluid);
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(attributes.getStillTexture());
    }

    public static class FluidBlobModel
    extends Model {
        private ModelPart blob;

        public FluidBlobModel(ModelPart root) {
            super(RenderType::entityTranslucent);
            this.blob = root.getChild("blob");
        }

        public static LayerDefinition createBlobLayer() {
            MeshDefinition mesh = new MeshDefinition();
            mesh.getRoot().addOrReplaceChild("blob", CubeListBuilder.create().addBox(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f), PartPose.ZERO);
            return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
        }

        public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
            this.blob.render(poseStack, buffer, packedLight, packedOverlay, color);
        }
    }
}

