/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.world;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import me.jddev0.ep.api.EPAPI;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public final class ModTemplatePools {
    public static final ResourceKey<StructureTemplatePool> FACTORY_1_START = ModTemplatePools.registerKey("factory_1/start_pool");
    public static final ResourceKey<StructureTemplatePool> SMALL_SOLAR_FARM_START = ModTemplatePools.registerKey("small_solar_farm/start_pool");

    private ModTemplatePools() {
    }

    public static void bootstrap(BootstrapContext<StructureTemplatePool> context) {
        HolderGetter templatePools = context.lookup(Registries.TEMPLATE_POOL);
        Holder.Reference emptyTemplatePool = templatePools.getOrThrow(Pools.EMPTY);
        context.register(FACTORY_1_START, (Object)new StructureTemplatePool((Holder)emptyTemplatePool, List.of(Pair.of((Object)StructurePoolElement.single((String)"energizedpower:factory/factory_1"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(SMALL_SOLAR_FARM_START, (Object)new StructureTemplatePool((Holder)emptyTemplatePool, List.of(Pair.of((Object)StructurePoolElement.single((String)"energizedpower:misc/small_solar_farm"), (Object)1)), StructureTemplatePool.Projection.RIGID));
    }

    public static ResourceKey<StructureTemplatePool> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)EPAPI.id(name));
    }
}

