/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.world;

import java.util.List;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.registry.tags.EnergizedPowerBiomeTags;
import me.jddev0.ep.world.ModTemplatePools;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;

public final class ModStructures {
    public static final ResourceKey<Structure> FACTORY_1 = ModStructures.registerKey("factory_1");
    public static final ResourceKey<Structure> SMALL_SOLAR_FARM = ModStructures.registerKey("small_solar_farm");

    private ModStructures() {
    }

    public static void bootstrap(BootstrapContext<Structure> context) {
        HolderGetter biomes = context.lookup(Registries.BIOME);
        HolderGetter templatePools = context.lookup(Registries.TEMPLATE_POOL);
        context.register(FACTORY_1, (Object)new JigsawStructure(new Structure.StructureSettings.Builder((HolderSet)biomes.getOrThrow(EnergizedPowerBiomeTags.HAS_STRUCTURE_FACTORY_1)).terrainAdapation(TerrainAdjustment.BEARD_BOX).generationStep(GenerationStep.Decoration.SURFACE_STRUCTURES).build(), (Holder)templatePools.getOrThrow(ModTemplatePools.FACTORY_1_START), Optional.empty(), 1, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)-1)), false, Optional.of(Heightmap.Types.WORLD_SURFACE_WG), 64, List.of(), JigsawStructure.DEFAULT_DIMENSION_PADDING, JigsawStructure.DEFAULT_LIQUID_SETTINGS));
        context.register(SMALL_SOLAR_FARM, (Object)new JigsawStructure(new Structure.StructureSettings.Builder((HolderSet)biomes.getOrThrow(EnergizedPowerBiomeTags.HAS_STRUCTURE_SMALL_SOLAR_FARM)).terrainAdapation(TerrainAdjustment.BEARD_BOX).generationStep(GenerationStep.Decoration.SURFACE_STRUCTURES).build(), (Holder)templatePools.getOrThrow(ModTemplatePools.SMALL_SOLAR_FARM_START), Optional.empty(), 1, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)0)), false, Optional.of(Heightmap.Types.WORLD_SURFACE_WG), 16, List.of(), JigsawStructure.DEFAULT_DIMENSION_PADDING, JigsawStructure.DEFAULT_LIQUID_SETTINGS));
    }

    public static ResourceKey<Structure> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)EPAPI.id(name));
    }
}

