/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public final class ItemStackUtils {
    private ItemStackUtils() {
    }

    public static List<ItemStack> combineItemStacks(List<ItemStack> itemStacks) {
        ArrayList<ItemStack> combinedItemStacks = new ArrayList<ItemStack>();
        for (ItemStack itemStack : itemStacks) {
            boolean inserted = false;
            int amountLeft = itemStack.getCount();
            for (ItemStack combinedItemStack : combinedItemStacks) {
                if (!ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)combinedItemStack) || !ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)combinedItemStack) || combinedItemStack.getMaxStackSize() <= combinedItemStack.getCount()) continue;
                int amount = Math.min(amountLeft, combinedItemStack.getMaxStackSize() - combinedItemStack.getCount());
                combinedItemStack.grow(amount);
                if ((amountLeft -= amount) != 0) continue;
                inserted = true;
                break;
            }
            if (inserted) continue;
            combinedItemStacks.add(itemStack.copyWithCount(amountLeft));
        }
        return combinedItemStacks;
    }
}

