/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen.base;

import java.util.ArrayList;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.ChangeRedstoneModeC2SPacket;
import me.jddev0.ep.screen.base.EnergyStorageContainerScreen;
import me.jddev0.ep.screen.base.IConfigurableMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class ConfigurableEnergyStorageContainerScreen<T extends AbstractContainerMenu & IConfigurableMenu>
extends EnergyStorageContainerScreen<T> {
    protected final ResourceLocation CONFIGURATION_ICONS_TEXTURE = EPAPI.id("textures/gui/machine_configuration/configuration_buttons.png");

    public ConfigurableEnergyStorageContainerScreen(T menu, Inventory inventory, Component titleComponent) {
        super(menu, inventory, titleComponent);
    }

    public ConfigurableEnergyStorageContainerScreen(T menu, Inventory inventory, Component titleComponent, ResourceLocation texture) {
        super(menu, inventory, titleComponent, texture);
    }

    public ConfigurableEnergyStorageContainerScreen(T menu, Inventory inventory, Component titleComponent, String energyIndicatorBarTooltipComponentID, ResourceLocation texture) {
        super(menu, inventory, titleComponent, energyIndicatorBarTooltipComponentID, texture);
    }

    protected boolean mouseClickedNormalView(double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    protected boolean mouseClickedConfiguration(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0 && this.isHovering(-22, 2, 20, 20, mouseX, mouseY)) {
            ModMessages.sendToServer(new ChangeRedstoneModeC2SPacket(((IConfigurableMenu)this.menu).getBlockEntity().getBlockPos()));
            return true;
        }
        return false;
    }

    public final boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean clicked = this.mouseClickedNormalView(mouseX, mouseY, mouseButton);
        if (clicked |= this.mouseClickedConfiguration(mouseX, mouseY, mouseButton)) {
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void renderBgNormalView(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
    }

    @Override
    protected final void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderBgNormalView(guiGraphics, partialTick, mouseX, mouseY);
        this.renderConfiguration(guiGraphics, x, y, mouseX, mouseY);
    }

    protected void renderConfiguration(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        RedstoneMode redstoneMode = ((IConfigurableMenu)this.menu).getRedstoneMode();
        int ordinal = redstoneMode.ordinal();
        if (this.isHovering(-22, 2, 20, 20, mouseX, mouseY)) {
            guiGraphics.blit(this.CONFIGURATION_ICONS_TEXTURE, x - 22, y + 2, (float)(20 * ordinal), 20.0f, 20, 20, 256, 256);
        } else {
            guiGraphics.blit(this.CONFIGURATION_ICONS_TEXTURE, x - 22, y + 2, (float)(20 * ordinal), 0.0f, 20, 20, 256, 256);
        }
    }

    protected void renderTooltipNormalView(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void renderTooltipConfiguration(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isHovering(-22, 2, 20, 20, mouseX, mouseY)) {
            RedstoneMode redstoneMode = ((IConfigurableMenu)this.menu).getRedstoneMode();
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            components.add(Component.translatable((String)("tooltip.energizedpower.machine_configuration.redstone_mode." + redstoneMode.getSerializedName())));
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
    }

    @Override
    protected final void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderTooltipNormalView(guiGraphics, mouseX, mouseY);
        this.renderTooltipConfiguration(guiGraphics, mouseX, mouseY);
    }
}

