/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.CraftPressMoldMakerRecipeC2SPacket;
import me.jddev0.ep.recipe.PressMoldMakerRecipe;
import me.jddev0.ep.screen.PressMoldMakerMenu;
import me.jddev0.ep.screen.base.EnergizedPowerBaseContainerScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PressMoldMakerScreen
extends EnergizedPowerBaseContainerScreen<PressMoldMakerMenu> {
    private final ResourceLocation TEXTURE = EPAPI.id("textures/gui/container/press_mold_maker.png");
    private int scrollIndexOffset = 0;

    public PressMoldMakerScreen(PressMoldMakerMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            boolean clicked = false;
            for (int j = 0; j < 2; ++j) {
                for (int i = 0; i < 4; ++i) {
                    int index;
                    if (!this.isHovering(35 + 30 * i, 18 + 30 * j, 20, 20, mouseX, mouseY) || (index = this.scrollIndexOffset + i + 4 * j) >= ((PressMoldMakerMenu)this.menu).getRecipeList().size() || !((Boolean)((PressMoldMakerMenu)this.menu).getRecipeList().get(index).getSecond()).booleanValue()) continue;
                    ModMessages.sendToServer(new CraftPressMoldMakerRecipeC2SPacket(((PressMoldMakerMenu)this.menu).getBlockEntity().getBlockPos(), ((RecipeHolder)((PressMoldMakerMenu)this.menu).getRecipeList().get(index).getFirst()).id()));
                    clicked = true;
                }
            }
            if (this.scrollIndexOffset > 0 && this.isHovering(155, 19, 11, 12, mouseX, mouseY)) {
                this.scrollIndexOffset -= 8;
                clicked = true;
            }
            if (this.scrollIndexOffset + 8 < ((PressMoldMakerMenu)this.menu).getRecipeList().size() && this.isHovering(155, 55, 11, 12, mouseX, mouseY)) {
                this.scrollIndexOffset += 8;
                clicked = true;
            }
            if (clicked) {
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        this.renderButtons(guiGraphics, x, y, mouseX, mouseY);
    }

    private void renderButtons(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        int buttonIndex = 0;
        for (int i = this.scrollIndexOffset; i < ((PressMoldMakerMenu)this.menu).getRecipeList().size() && buttonIndex < 8; ++i, ++buttonIndex) {
            ItemStack output;
            int btnX = 35 + 30 * (buttonIndex % 4);
            int btnY = 18 + 30 * (buttonIndex / 4);
            if (((Boolean)((PressMoldMakerMenu)this.menu).getRecipeList().get(i).getSecond()).booleanValue()) {
                if (this.isHovering(btnX, btnY, 20, 20, mouseX, mouseY)) {
                    guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + btnX, y + btnY, 0, 211, 20, 20);
                } else {
                    guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + btnX, y + btnY, 0, 231, 20, 20);
                }
            }
            if ((output = ((PressMoldMakerRecipe)((RecipeHolder)((PressMoldMakerMenu)this.menu).getRecipeList().get(i).getFirst()).value()).getOutput()).isEmpty()) continue;
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
            guiGraphics.renderItem(output, x + btnX + 2, y + btnY + 2, btnX + 2 + (btnY + 2) * this.imageWidth);
            guiGraphics.pose().popPose();
        }
        if (this.scrollIndexOffset > 0) {
            if (this.isHovering(155, 19, 11, 12, mouseX, mouseY)) {
                guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 155, y + 19, 11, 187, 11, 12);
            } else {
                guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 155, y + 19, 11, 199, 11, 12);
            }
        }
        if (this.scrollIndexOffset + 8 < ((PressMoldMakerMenu)this.menu).getRecipeList().size()) {
            if (this.isHovering(155, 55, 11, 12, mouseX, mouseY)) {
                guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 155, y + 55, 0, 187, 11, 12);
            } else {
                guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 155, y + 55, 0, 199, 11, 12);
            }
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        int buttonIndex = 0;
        for (int i = this.scrollIndexOffset; i < ((PressMoldMakerMenu)this.menu).getRecipeList().size() && buttonIndex < 8; ++i, ++buttonIndex) {
            PressMoldMakerRecipe recipe;
            ItemStack output;
            int btnX = 35 + 30 * (buttonIndex % 4);
            int btnY = 18 + 30 * (buttonIndex / 4);
            if (!this.isHovering(btnX, btnY, 20, 20, mouseX, mouseY) || (output = (recipe = (PressMoldMakerRecipe)((RecipeHolder)((PressMoldMakerMenu)this.menu).getRecipeList().get(i).getFirst()).value()).getOutput()).isEmpty()) continue;
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            components.add(Component.translatable((String)"tooltip.energizedpower.count_with_item.txt", (Object[])new Object[]{output.getCount(), output.getHoverName()}));
            components.add(Component.translatable((String)"tooltip.energizedpower.press_mold_maker.btn.recipes", (Object[])new Object[]{recipe.getClayCount(), Component.translatable((String)Items.CLAY_BALL.getDescriptionId())}).withStyle(ChatFormatting.ITALIC));
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
        if (this.isHovering(155, 19, 11, 12, mouseX, mouseY)) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            components.add(Component.translatable((String)"tooltip.energizedpower.press_mold_maker.btn.up"));
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
        if (this.isHovering(155, 55, 11, 12, mouseX, mouseY)) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            components.add(Component.translatable((String)"tooltip.energizedpower.press_mold_maker.btn.down"));
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

