/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import me.jddev0.ep.inventory.ConstraintInsertSlot;
import me.jddev0.ep.item.InventoryChargerItem;
import me.jddev0.ep.screen.EPMenuTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class InventoryChargerMenu
extends AbstractContainerMenu {
    private final Container container;
    private final Level level;

    public InventoryChargerMenu(int id, Inventory inv, FriendlyByteBuf buffer) {
        this(id, inv, (Container)new SimpleContainer(InventoryChargerItem.SLOT_COUNT){

            public boolean canPlaceItem(int slot, @NotNull ItemStack stack) {
                if (slot >= 0 && slot < this.getContainerSize()) {
                    IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
                    return energyStorage != null && energyStorage.canExtract();
                }
                return super.canPlaceItem(slot, stack);
            }

            public int getMaxStackSize() {
                return 1;
            }
        });
    }

    public InventoryChargerMenu(int id, Inventory inv, Container container) {
        super(EPMenuTypes.INVENTORY_CHARGER_MENU.get(), id);
        InventoryChargerMenu.checkContainerSize((Container)inv, (int)InventoryChargerItem.SLOT_COUNT);
        this.container = container;
        this.level = inv.player.level();
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        int slotIndex = 0;
        if (container.getContainerSize() >= 5) {
            this.addSlot(new ConstraintInsertSlot(container, slotIndex++, 44, 35));
        }
        if (container.getContainerSize() >= 3) {
            this.addSlot(new ConstraintInsertSlot(container, slotIndex++, 62, 35));
        }
        if (container.getContainerSize() >= 1) {
            this.addSlot(new ConstraintInsertSlot(container, slotIndex++, 80, 35));
        }
        if (container.getContainerSize() >= 3) {
            this.addSlot(new ConstraintInsertSlot(container, slotIndex++, 98, 35));
        }
        if (container.getContainerSize() >= 5) {
            this.addSlot(new ConstraintInsertSlot(container, slotIndex, 116, 35));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceItem = sourceSlot.getItem();
        ItemStack sourceItemCopy = sourceItem.copy();
        if (index < 36) {
            if (!this.moveItemStackTo(sourceItem, 36, 36 + this.container.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 36 + this.container.getContainerSize()) {
            if (!this.moveItemStackTo(sourceItem, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            throw new IllegalArgumentException("Invalid slot index");
        }
        if (sourceItem.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(player, sourceItem);
        return sourceItemCopy;
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

