/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import me.jddev0.ep.block.entity.FluidTankBlockEntity;
import me.jddev0.ep.inventory.data.SimpleBooleanValueContainerData;
import me.jddev0.ep.machine.tier.FluidTankTier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidTankMenu
extends AbstractContainerMenu {
    private final FluidTankBlockEntity blockEntity;
    private final Level level;
    private final SimpleBooleanValueContainerData ignoreNBTData = new SimpleBooleanValueContainerData();

    public FluidTankMenu(int id, Inventory inv, FriendlyByteBuf buffer) {
        this(id, inv, inv.player.level().getBlockEntity(buffer.readBlockPos()), null);
    }

    public FluidTankMenu(int id, Inventory inv, BlockEntity blockEntity, ContainerData data) {
        super(((FluidTankBlockEntity)blockEntity).getTier().getMenuTypeFromTier(), id);
        this.blockEntity = (FluidTankBlockEntity)blockEntity;
        this.level = inv.player.level();
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        if (data == null) {
            this.addDataSlots(this.ignoreNBTData);
        } else {
            this.addDataSlots(data);
        }
    }

    public FluidTankTier getTier() {
        return this.blockEntity.getTier();
    }

    public FluidStack getFluid(int tank) {
        return this.blockEntity.getFluid(tank);
    }

    public int getTankCapacity(int tank) {
        return this.blockEntity.getTankCapacity(tank);
    }

    public boolean isIgnoreNBT() {
        return this.ignoreNBTData.getValue();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return FluidTankMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)this.getTier().getBlockFromTier());
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

