/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.block.entity.CreativeItemSiloBlockEntity;
import me.jddev0.ep.inventory.CreativeItemSiloSlot;
import me.jddev0.ep.inventory.InfiniteSingleItemStackHandler;
import me.jddev0.ep.inventory.ItemCapabilityMenuHelper;
import me.jddev0.ep.screen.EPMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CreativeItemSiloMenu
extends AbstractContainerMenu {
    private final CreativeItemSiloBlockEntity blockEntity;
    private final Level level;

    public CreativeItemSiloMenu(int id, Inventory inv, FriendlyByteBuf buffer) {
        this(id, inv, inv.player.level().getBlockEntity(buffer.readBlockPos()));
    }

    public CreativeItemSiloMenu(int id, Inventory inv, BlockEntity blockEntity) {
        super(EPMenuTypes.CREATIVE_ITEM_SILO_MENU.get(), id);
        this.blockEntity = (CreativeItemSiloBlockEntity)blockEntity;
        this.level = inv.player.level();
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        ItemCapabilityMenuHelper.getCapabilityItemHandler(this.level, this.blockEntity).ifPresent(itemHandler -> {
            if (itemHandler instanceof InfiniteSingleItemStackHandler) {
                InfiniteSingleItemStackHandler singleItemStackHandler = (InfiniteSingleItemStackHandler)((Object)itemHandler);
                this.addSlot(new CreativeItemSiloSlot(singleItemStackHandler, 0, 80, 35));
            }
        });
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return CreativeItemSiloMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)EPBlocks.CREATIVE_ITEM_SILO.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

