/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import java.util.ArrayList;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.entity.AutoStonecutterBlockEntity;
import me.jddev0.ep.screen.AutoStonecutterMenu;
import me.jddev0.ep.screen.base.SelectableRecipeMachineContainerScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AutoStonecutterScreen
extends SelectableRecipeMachineContainerScreen<StonecutterRecipe, AutoStonecutterMenu> {
    public AutoStonecutterScreen(AutoStonecutterMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component, "tooltip.energizedpower.recipe.energy_required_to_finish.txt", EPAPI.id("textures/gui/container/auto_stonecutter.png"), EPAPI.id("textures/gui/container/upgrade_view/1_speed_1_energy_efficiency_1_energy_capacity.png"));
    }

    @Override
    protected ItemStack getRecipeIcon(RecipeHolder<StonecutterRecipe> currentRecipe) {
        return ((StonecutterRecipe)currentRecipe.value()).getResultItem((HolderLookup.Provider)((AutoStonecutterBlockEntity)((AutoStonecutterMenu)this.menu).getBlockEntity()).getLevel().registryAccess());
    }

    @Override
    protected void renderCurrentRecipeTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, RecipeHolder<StonecutterRecipe> currentRecipe) {
        ItemStack output = ((StonecutterRecipe)currentRecipe.value()).getResultItem((HolderLookup.Provider)((AutoStonecutterBlockEntity)((AutoStonecutterMenu)this.menu).getBlockEntity()).getLevel().registryAccess());
        if (!output.isEmpty()) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            components.add(Component.translatable((String)"tooltip.energizedpower.count_with_item.txt", (Object[])new Object[]{output.getCount(), output.getHoverName()}));
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
    }

    @Override
    protected void renderBgNormalView(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBgNormalView(guiGraphics, partialTick, mouseX, mouseY);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderProgressArrow(guiGraphics, x, y);
    }

    private void renderProgressArrow(GuiGraphics guiGraphics, int x, int y) {
        if (((AutoStonecutterMenu)this.menu).isCraftingActive()) {
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 84, y + 43, 0, 58, ((AutoStonecutterMenu)this.menu).getScaledProgressArrowSize(), 17);
        }
    }

    @Override
    protected void renderTooltipNormalView(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltipNormalView(guiGraphics, mouseX, mouseY);
        if (this.isHovering(57, 44, 16, 16, mouseX, mouseY) && ((AutoStonecutterMenu)this.menu).getSlot(37).getItem().isEmpty()) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            components.add(Component.translatable((String)"tooltip.energizedpower.auto_stonecutter.pickaxe_missing").withStyle(ChatFormatting.RED));
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

