/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.block.entity.AutoCrafterBlockEntity;
import me.jddev0.ep.inventory.ItemCapabilityMenuHelper;
import me.jddev0.ep.inventory.PatternResultSlot;
import me.jddev0.ep.inventory.PatternSlot;
import me.jddev0.ep.inventory.UpgradeModuleSlot;
import me.jddev0.ep.inventory.data.SimpleBooleanValueContainerData;
import me.jddev0.ep.inventory.data.SimpleComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.SimpleEnergyValueContainerData;
import me.jddev0.ep.inventory.data.SimpleProgressValueContainerData;
import me.jddev0.ep.inventory.data.SimpleRedstoneModeValueContainerData;
import me.jddev0.ep.inventory.upgrade.UpgradeModuleInventory;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.EPMenuTypes;
import me.jddev0.ep.screen.base.IConfigurableMenu;
import me.jddev0.ep.screen.base.IEnergyStorageConsumerIndicatorBarMenu;
import me.jddev0.ep.screen.base.UpgradableEnergyStorageMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.SlotItemHandler;

public class AutoCrafterMenu
extends UpgradableEnergyStorageMenu<AutoCrafterBlockEntity>
implements IEnergyStorageConsumerIndicatorBarMenu,
IConfigurableMenu {
    private final Container patternSlots;
    private final Container patternResultSlots;
    private final SimpleProgressValueContainerData progressData = new SimpleProgressValueContainerData();
    private final SimpleProgressValueContainerData maxProgressData = new SimpleProgressValueContainerData();
    private final SimpleEnergyValueContainerData energyConsumptionPerTickData = new SimpleEnergyValueContainerData();
    private final SimpleEnergyValueContainerData energyConsumptionLeftData = new SimpleEnergyValueContainerData();
    private final SimpleBooleanValueContainerData hasEnoughEnergyData = new SimpleBooleanValueContainerData();
    private final SimpleBooleanValueContainerData ignoreNBTData = new SimpleBooleanValueContainerData();
    private final SimpleBooleanValueContainerData secondaryExtractModeData = new SimpleBooleanValueContainerData();
    private final SimpleBooleanValueContainerData allowOutputOverflowData = new SimpleBooleanValueContainerData();
    private final SimpleRedstoneModeValueContainerData redstoneModeData = new SimpleRedstoneModeValueContainerData();
    private final SimpleComparatorModeValueContainerData comparatorModeData = new SimpleComparatorModeValueContainerData();

    public AutoCrafterMenu(int id, Inventory inv, FriendlyByteBuf buffer) {
        this(id, inv, inv.player.level().getBlockEntity(buffer.readBlockPos()), new UpgradeModuleInventory(UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY), (Container)new SimpleContainer(9), (Container)new SimpleContainer(1), null);
    }

    public AutoCrafterMenu(int id, Inventory inv, BlockEntity blockEntity, UpgradeModuleInventory upgradeModuleInventory, Container patternSlots, Container patternResultSlots, ContainerData data) {
        super(EPMenuTypes.AUTO_CRAFTER_MENU.get(), id, inv, blockEntity, (Block)EPBlocks.AUTO_CRAFTER.get(), 8, 124, upgradeModuleInventory, 3);
        int i;
        this.patternSlots = patternSlots;
        this.patternResultSlots = patternResultSlots;
        ItemCapabilityMenuHelper.getCapabilityItemHandler(this.level, this.blockEntity).ifPresent(itemHandler -> {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.addSlot((Slot)new SlotItemHandler(itemHandler, 9 * i + j, 8 + 18 * j, 75 + 18 * i));
                }
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.addSlot(new PatternSlot(patternSlots, j + i * 3, 30 + j * 18, 17 + i * 18, () -> true){

                    public boolean isActive() {
                        return super.isActive() && !AutoCrafterMenu.this.isInUpgradeModuleView();
                    }
                });
            }
        }
        this.addSlot(new PatternResultSlot(patternResultSlots, 0, 124, 35, () -> true){

            public boolean isActive() {
                return super.isActive() && !AutoCrafterMenu.this.isInUpgradeModuleView();
            }
        });
        for (i = 0; i < upgradeModuleInventory.getContainerSize(); ++i) {
            this.addSlot(new UpgradeModuleSlot((Container)upgradeModuleInventory, i, 62 + i * 18, 35, this::isInUpgradeModuleView));
        }
        if (data == null) {
            this.addDataSlots(this.progressData);
            this.addDataSlots(this.maxProgressData);
            this.addDataSlots(this.energyConsumptionPerTickData);
            this.addDataSlots(this.energyConsumptionLeftData);
            this.addDataSlots(this.hasEnoughEnergyData);
            this.addDataSlots(this.ignoreNBTData);
            this.addDataSlots(this.secondaryExtractModeData);
            this.addDataSlots(this.allowOutputOverflowData);
            this.addDataSlots(this.redstoneModeData);
            this.addDataSlots(this.comparatorModeData);
        } else {
            this.addDataSlots(data);
        }
    }

    public Container getPatternSlots() {
        return this.patternSlots;
    }

    @Override
    public int getEnergyIndicatorBarValue() {
        return this.energyConsumptionLeftData.getValue();
    }

    @Override
    public int getEnergyPerTickBarValue() {
        return this.energyConsumptionPerTickData.getValue();
    }

    public boolean isCraftingActive() {
        return this.progressData.getValue() > 0;
    }

    public boolean isCrafting() {
        return this.progressData.getValue() > 0 && this.hasEnoughEnergyData.getValue();
    }

    public int getScaledProgressArrowSize() {
        int progress = this.progressData.getValue();
        int maxProgress = this.maxProgressData.getValue();
        int progressArrowSize = 24;
        return maxProgress == 0 || progress == 0 ? 0 : progress * progressArrowSize / maxProgress;
    }

    public boolean isIgnoreNBT() {
        return this.ignoreNBTData.getValue();
    }

    public boolean isSecondaryExtractMode() {
        return this.secondaryExtractModeData.getValue();
    }

    public boolean isAllowOutputOverflow() {
        return this.allowOutputOverflowData.getValue();
    }

    @Override
    public RedstoneMode getRedstoneMode() {
        return this.redstoneModeData.getValue();
    }

    @Override
    public ComparatorMode getComparatorMode() {
        return this.comparatorModeData.getValue();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceItem = sourceSlot.getItem();
        ItemStack sourceItemCopy = sourceItem.copy();
        if (index < 36) {
            if (!this.moveItemStackTo(sourceItem, 64, 67, false) && !this.moveItemStackTo(sourceItem, 39, 54, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 54) {
            if (!this.moveItemStackTo(sourceItem, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            if (index < 64) {
                return ItemStack.EMPTY;
            }
            if (index < 67) {
                if (!this.moveItemStackTo(sourceItem, 0, 36, false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                throw new IllegalArgumentException("Invalid slot index");
            }
        }
        if (sourceItem.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(player, sourceItem);
        return sourceItemCopy;
    }
}

