/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.screen.AlloyFurnaceMenu;
import me.jddev0.ep.screen.base.EnergizedPowerBaseContainerScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AlloyFurnaceScreen
extends EnergizedPowerBaseContainerScreen<AlloyFurnaceMenu> {
    private final ResourceLocation TEXTURE = EPAPI.id("textures/gui/container/alloy_furnace.png");

    public AlloyFurnaceScreen(AlloyFurnaceMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        this.renderProgressFlame(guiGraphics, x, y);
        this.renderProgressArrow(guiGraphics, x, y);
    }

    private void renderProgressFlame(GuiGraphics guiGraphics, int x, int y) {
        if (((AlloyFurnaceMenu)this.menu).isBurningFuel()) {
            int pos = ((AlloyFurnaceMenu)this.menu).getScaledProgressFlameSize();
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 36, y + 37 + 14 - pos, 0, 135 - pos, 14, pos);
        }
    }

    private void renderProgressArrow(GuiGraphics guiGraphics, int x, int y) {
        if (((AlloyFurnaceMenu)this.menu).isCraftingActive()) {
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 79, y + 34, 0, 58, ((AlloyFurnaceMenu)this.menu).getScaledProgressArrowSize(), 17);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }
}

