/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.block.entity.AlloyFurnaceBlockEntity;
import me.jddev0.ep.inventory.ItemCapabilityMenuHelper;
import me.jddev0.ep.inventory.data.SimpleProgressValueContainerData;
import me.jddev0.ep.screen.EPMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.SlotItemHandler;

public class AlloyFurnaceMenu
extends AbstractContainerMenu {
    private final AlloyFurnaceBlockEntity blockEntity;
    private final Level level;
    private final SimpleProgressValueContainerData progressData = new SimpleProgressValueContainerData();
    private final SimpleProgressValueContainerData maxProgressData = new SimpleProgressValueContainerData();
    private final SimpleProgressValueContainerData litDurationData = new SimpleProgressValueContainerData();
    private final SimpleProgressValueContainerData maxLitDurationData = new SimpleProgressValueContainerData();

    public AlloyFurnaceMenu(int id, Inventory inv, FriendlyByteBuf buffer) {
        this(id, inv, inv.player.level().getBlockEntity(buffer.readBlockPos()), null);
    }

    public AlloyFurnaceMenu(int id, Inventory inv, BlockEntity blockEntity, ContainerData data) {
        super(EPMenuTypes.ALLOY_FURNACE_MENU.get(), id);
        this.blockEntity = (AlloyFurnaceBlockEntity)blockEntity;
        this.level = inv.player.level();
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        ItemCapabilityMenuHelper.getCapabilityItemHandler(this.level, this.blockEntity).ifPresent(itemHandler -> {
            this.addSlot((Slot)new SlotItemHandler(itemHandler, 0, 14, 20));
            this.addSlot((Slot)new SlotItemHandler(itemHandler, 1, 35, 17));
            this.addSlot((Slot)new SlotItemHandler(itemHandler, 2, 56, 20));
            this.addSlot((Slot)new SlotItemHandler(itemHandler, 3, 35, 53));
            this.addSlot((Slot)new SlotItemHandler(itemHandler, 4, 116, 35));
            this.addSlot((Slot)new SlotItemHandler(itemHandler, 5, 143, 35));
        });
        if (data == null) {
            this.addDataSlots(this.progressData);
            this.addDataSlots(this.maxProgressData);
            this.addDataSlots(this.litDurationData);
            this.addDataSlots(this.maxLitDurationData);
        } else {
            this.addDataSlots(data);
        }
    }

    public boolean isCraftingActive() {
        return this.progressData.getValue() > 0;
    }

    public int getScaledProgressArrowSize() {
        int progress = this.progressData.getValue();
        int maxProgress = this.maxProgressData.getValue();
        int progressArrowSize = 24;
        return maxProgress == 0 || progress == 0 ? 0 : progress * progressArrowSize / maxProgress;
    }

    public boolean isBurningFuel() {
        return this.litDurationData.getValue() > 0;
    }

    public int getScaledProgressFlameSize() {
        int progress = this.litDurationData.getValue();
        int maxProgress = this.maxLitDurationData.getValue();
        int progressFlameSize = 14;
        return maxProgress == 0 || progress == 0 ? 0 : progress * progressFlameSize / maxProgress;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceItem = sourceSlot.getItem();
        ItemStack sourceItemCopy = sourceItem.copy();
        if (index < 36) {
            if (!this.moveItemStackTo(sourceItem, 36, 40, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 42) {
            if (!this.moveItemStackTo(sourceItem, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            throw new IllegalArgumentException("Invalid slot index");
        }
        if (sourceItem.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(player, sourceItem);
        return sourceItemCopy;
    }

    public boolean stillValid(Player player) {
        return AlloyFurnaceMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)EPBlocks.ALLOY_FURNACE.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

