/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.block.entity.AdvancedUnchargerBlockEntity;
import me.jddev0.ep.inventory.ItemCapabilityMenuHelper;
import me.jddev0.ep.inventory.UpgradeModuleSlot;
import me.jddev0.ep.inventory.data.SimpleComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.SimpleEnergyValueContainerData;
import me.jddev0.ep.inventory.data.SimpleRedstoneModeValueContainerData;
import me.jddev0.ep.inventory.upgrade.UpgradeModuleInventory;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.EPMenuTypes;
import me.jddev0.ep.screen.base.IConfigurableMenu;
import me.jddev0.ep.screen.base.IEnergyStorageProducerIndicatorBarMenu;
import me.jddev0.ep.screen.base.UpgradableEnergyStorageMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class AdvancedUnchargerMenu
extends UpgradableEnergyStorageMenu<AdvancedUnchargerBlockEntity>
implements IEnergyStorageProducerIndicatorBarMenu,
IConfigurableMenu {
    private final SimpleEnergyValueContainerData energyProductionPerTickData = new SimpleEnergyValueContainerData();
    private final SimpleEnergyValueContainerData[] energyProductionLeftData = new SimpleEnergyValueContainerData[]{new SimpleEnergyValueContainerData(), new SimpleEnergyValueContainerData(), new SimpleEnergyValueContainerData()};
    private final SimpleRedstoneModeValueContainerData redstoneModeData = new SimpleRedstoneModeValueContainerData();
    private final SimpleComparatorModeValueContainerData comparatorModeData = new SimpleComparatorModeValueContainerData();

    public AdvancedUnchargerMenu(int id, Inventory inv, FriendlyByteBuf buffer) {
        this(id, inv, inv.player.level().getBlockEntity(buffer.readBlockPos()), new UpgradeModuleInventory(UpgradeModuleModifier.ENERGY_CAPACITY), null);
    }

    public AdvancedUnchargerMenu(int id, Inventory inv, BlockEntity blockEntity, UpgradeModuleInventory upgradeModuleInventory, ContainerData data) {
        super(EPMenuTypes.ADVANCED_UNCHARGER_MENU.get(), id, inv, blockEntity, (Block)EPBlocks.ADVANCED_UNCHARGER.get(), upgradeModuleInventory, 1);
        ItemCapabilityMenuHelper.getCapabilityItemHandler(this.level, this.blockEntity).ifPresent(itemHandler -> {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, 0, 41, 35){

                public boolean isActive() {
                    return super.isActive() && !AdvancedUnchargerMenu.this.isInUpgradeModuleView();
                }
            });
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, 1, 89, 35){

                public boolean isActive() {
                    return super.isActive() && !AdvancedUnchargerMenu.this.isInUpgradeModuleView();
                }
            });
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, 2, 137, 35){

                public boolean isActive() {
                    return super.isActive() && !AdvancedUnchargerMenu.this.isInUpgradeModuleView();
                }
            });
        });
        this.addSlot(new UpgradeModuleSlot((Container)upgradeModuleInventory, 0, 80, 35, this::isInUpgradeModuleView));
        if (data == null) {
            this.addDataSlots(this.energyProductionPerTickData);
            this.addDataSlots(this.energyProductionLeftData[0]);
            this.addDataSlots(this.energyProductionLeftData[1]);
            this.addDataSlots(this.energyProductionLeftData[2]);
            this.addDataSlots(this.redstoneModeData);
            this.addDataSlots(this.comparatorModeData);
        } else {
            this.addDataSlots(data);
        }
    }

    @Override
    public int getEnergyIndicatorBarValue() {
        int energyIndicatorBarValueSum = -1;
        for (SimpleEnergyValueContainerData ele : this.energyProductionLeftData) {
            int value = ele.getValue();
            if ((long)(energyIndicatorBarValueSum + value) != (long)energyIndicatorBarValueSum + (long)value) {
                return Integer.MAX_VALUE;
            }
            if (value <= -1) continue;
            if (energyIndicatorBarValueSum == -1) {
                ++energyIndicatorBarValueSum;
            }
            energyIndicatorBarValueSum += value;
        }
        return energyIndicatorBarValueSum;
    }

    @Override
    public int getEnergyPerTickBarValue() {
        return this.energyProductionPerTickData.getValue();
    }

    @Override
    public RedstoneMode getRedstoneMode() {
        return this.redstoneModeData.getValue();
    }

    @Override
    public ComparatorMode getComparatorMode() {
        return this.comparatorModeData.getValue();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceItem = sourceSlot.getItem();
        ItemStack sourceItemCopy = sourceItem.copy();
        if (index < 36) {
            if (!this.moveItemStackTo(sourceItem, 39, 40, false) && !this.moveItemStackTo(sourceItem, 36, 39, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 40) {
            if (!this.moveItemStackTo(sourceItem, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            throw new IllegalArgumentException("Invalid slot index");
        }
        if (sourceItem.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(player, sourceItem);
        return sourceItemCopy;
    }
}

