/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.block.entity.AdvancedPoweredFurnaceBlockEntity;
import me.jddev0.ep.inventory.ItemCapabilityMenuHelper;
import me.jddev0.ep.inventory.UpgradeModuleSlot;
import me.jddev0.ep.inventory.data.SimpleBooleanValueContainerData;
import me.jddev0.ep.inventory.data.SimpleComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.SimpleEnergyValueContainerData;
import me.jddev0.ep.inventory.data.SimpleProgressValueContainerData;
import me.jddev0.ep.inventory.data.SimpleRedstoneModeValueContainerData;
import me.jddev0.ep.inventory.upgrade.UpgradeModuleInventory;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.EPMenuTypes;
import me.jddev0.ep.screen.base.IConfigurableMenu;
import me.jddev0.ep.screen.base.IEnergyStorageConsumerIndicatorBarMenu;
import me.jddev0.ep.screen.base.UpgradableEnergyStorageMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class AdvancedPoweredFurnaceMenu
extends UpgradableEnergyStorageMenu<AdvancedPoweredFurnaceBlockEntity>
implements IEnergyStorageConsumerIndicatorBarMenu,
IConfigurableMenu {
    private final SimpleProgressValueContainerData[] progressData = new SimpleProgressValueContainerData[]{new SimpleProgressValueContainerData(), new SimpleProgressValueContainerData(), new SimpleProgressValueContainerData()};
    private final SimpleProgressValueContainerData[] maxProgressData = new SimpleProgressValueContainerData[]{new SimpleProgressValueContainerData(), new SimpleProgressValueContainerData(), new SimpleProgressValueContainerData()};
    private final SimpleEnergyValueContainerData energyConsumptionPerTickData = new SimpleEnergyValueContainerData();
    private final SimpleEnergyValueContainerData[] energyConsumptionLeftData = new SimpleEnergyValueContainerData[]{new SimpleEnergyValueContainerData(), new SimpleEnergyValueContainerData(), new SimpleEnergyValueContainerData()};
    private final SimpleBooleanValueContainerData[] hasEnoughEnergyData = new SimpleBooleanValueContainerData[]{new SimpleBooleanValueContainerData(), new SimpleBooleanValueContainerData(), new SimpleBooleanValueContainerData()};
    private final SimpleRedstoneModeValueContainerData redstoneModeData = new SimpleRedstoneModeValueContainerData();
    private final SimpleComparatorModeValueContainerData comparatorModeData = new SimpleComparatorModeValueContainerData();

    public AdvancedPoweredFurnaceMenu(int id, Inventory inv, FriendlyByteBuf buffer) {
        this(id, inv, inv.player.level().getBlockEntity(buffer.readBlockPos()), new UpgradeModuleInventory(UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY, UpgradeModuleModifier.FURNACE_MODE), null);
    }

    public AdvancedPoweredFurnaceMenu(int id, Inventory inv, BlockEntity blockEntity, UpgradeModuleInventory upgradeModuleInventory, ContainerData data) {
        super(EPMenuTypes.ADVANCED_POWERED_FURNACE_MENU.get(), id, inv, blockEntity, (Block)EPBlocks.ADVANCED_POWERED_FURNACE.get(), upgradeModuleInventory, 4);
        ItemCapabilityMenuHelper.getCapabilityItemHandler(this.level, this.blockEntity).ifPresent(itemHandler -> {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, 0, 44, 17){

                public boolean isActive() {
                    return super.isActive() && !AdvancedPoweredFurnaceMenu.this.isInUpgradeModuleView();
                }
            });
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, 1, 98, 17){

                public boolean isActive() {
                    return super.isActive() && !AdvancedPoweredFurnaceMenu.this.isInUpgradeModuleView();
                }
            });
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, 2, 152, 17){

                public boolean isActive() {
                    return super.isActive() && !AdvancedPoweredFurnaceMenu.this.isInUpgradeModuleView();
                }
            });
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, 3, 44, 53){

                public boolean isActive() {
                    return super.isActive() && !AdvancedPoweredFurnaceMenu.this.isInUpgradeModuleView();
                }
            });
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, 4, 98, 53){

                public boolean isActive() {
                    return super.isActive() && !AdvancedPoweredFurnaceMenu.this.isInUpgradeModuleView();
                }
            });
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, 5, 152, 53){

                public boolean isActive() {
                    return super.isActive() && !AdvancedPoweredFurnaceMenu.this.isInUpgradeModuleView();
                }
            });
        });
        for (int i = 0; i < upgradeModuleInventory.getContainerSize(); ++i) {
            this.addSlot(new UpgradeModuleSlot((Container)upgradeModuleInventory, i, 53 + i * 18, 35, this::isInUpgradeModuleView));
        }
        if (data == null) {
            this.addDataSlots(this.progressData[0]);
            this.addDataSlots(this.progressData[1]);
            this.addDataSlots(this.progressData[2]);
            this.addDataSlots(this.maxProgressData[0]);
            this.addDataSlots(this.maxProgressData[1]);
            this.addDataSlots(this.maxProgressData[2]);
            this.addDataSlots(this.energyConsumptionPerTickData);
            this.addDataSlots(this.energyConsumptionLeftData[0]);
            this.addDataSlots(this.energyConsumptionLeftData[1]);
            this.addDataSlots(this.energyConsumptionLeftData[2]);
            this.addDataSlots(this.hasEnoughEnergyData[0]);
            this.addDataSlots(this.hasEnoughEnergyData[1]);
            this.addDataSlots(this.hasEnoughEnergyData[2]);
            this.addDataSlots(this.redstoneModeData);
            this.addDataSlots(this.comparatorModeData);
        } else {
            this.addDataSlots(data);
        }
    }

    @Override
    public int getEnergyIndicatorBarValue() {
        int energyIndicatorBarValueSum = -1;
        for (SimpleEnergyValueContainerData ele : this.energyConsumptionLeftData) {
            int value = ele.getValue();
            if ((long)(energyIndicatorBarValueSum + value) != (long)energyIndicatorBarValueSum + (long)value) {
                return Integer.MAX_VALUE;
            }
            if (value <= -1) continue;
            if (energyIndicatorBarValueSum == -1) {
                ++energyIndicatorBarValueSum;
            }
            energyIndicatorBarValueSum += value;
        }
        return energyIndicatorBarValueSum;
    }

    @Override
    public int getEnergyPerTickBarValue() {
        return this.energyConsumptionPerTickData.getValue();
    }

    public boolean isCraftingActive(int index) {
        return this.progressData[index].getValue() > 0;
    }

    public boolean isCrafting(int index) {
        return this.progressData[index].getValue() > 0 && this.hasEnoughEnergyData[index].getValue();
    }

    public int getScaledProgressArrowSize(int index) {
        int progress = this.progressData[index].getValue();
        int maxProgress = this.maxProgressData[index].getValue();
        int progressArrowSize = 17;
        return maxProgress == 0 || progress == 0 ? 0 : progress * progressArrowSize / maxProgress;
    }

    @Override
    public RedstoneMode getRedstoneMode() {
        return this.redstoneModeData.getValue();
    }

    @Override
    public ComparatorMode getComparatorMode() {
        return this.comparatorModeData.getValue();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceItem = sourceSlot.getItem();
        ItemStack sourceItemCopy = sourceItem.copy();
        if (index < 36) {
            if (!this.moveItemStackTo(sourceItem, 42, 46, false) && !this.moveItemStackTo(sourceItem, 36, 39, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 46) {
            if (!this.moveItemStackTo(sourceItem, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            throw new IllegalArgumentException("Invalid slot index");
        }
        if (sourceItem.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(player, sourceItem);
        return sourceItemCopy;
    }
}

