/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.entity.AdvancedFluidPumpBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.screen.AdvancedFluidPumpMenu;
import me.jddev0.ep.screen.base.ConfigurableUpgradableEnergyStorageContainerScreen;
import me.jddev0.ep.util.FluidUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedFluidPumpScreen
extends ConfigurableUpgradableEnergyStorageContainerScreen<AdvancedFluidPumpMenu> {
    public static final boolean SHOW_RELATIVE_COORDINATES = ModConfigs.CLIENT_FLUID_PUMP_RELATIVE_TARGET_COORDINATES.getValue();

    public AdvancedFluidPumpScreen(AdvancedFluidPumpMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component, "tooltip.energizedpower.fluid_pump.process_energy_left.txt", EPAPI.id("textures/gui/container/advanced_fluid_pump.png"), EPAPI.id("textures/gui/container/upgrade_view/advanced_fluid_pump.png"));
        this.imageWidth = 248;
    }

    @Override
    protected void renderBgNormalView(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBgNormalView(guiGraphics, partialTick, mouseX, mouseY);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        for (int i = 0; i < 4; ++i) {
            this.renderFluidMeterContent(guiGraphics, ((AdvancedFluidPumpMenu)this.menu).getFluid(i), ((AdvancedFluidPumpMenu)this.menu).getTankCapacity(i), x + 206 + i % 2 * 18, y + 17 + i / 2 * 54, 16, 52);
            this.renderFluidMeterOverlay(guiGraphics, x, y, i);
        }
        this.renderInfoText(guiGraphics, x, y);
    }

    private void renderFluidMeterOverlay(GuiGraphics guiGraphics, int x, int y, int tank) {
        guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 206 + tank % 2 * 18, y + 17 + tank / 2 * 54, 16.0f, 0.0f, 16, 52, 256, 256);
    }

    private void renderInfoText(GuiGraphics guiGraphics, int x, int y) {
        FluidState targetFluidState;
        BlockPos targetPos = ((AdvancedFluidPumpBlockEntity)((AdvancedFluidPumpMenu)this.menu).getBlockEntity()).getBlockPos().offset((Vec3i)((AdvancedFluidPumpMenu)this.menu).getTargetOffset());
        MutableComponent component = SHOW_RELATIVE_COORDINATES ? Component.translatable((String)"tooltip.energizedpower.fluid_pump.target_relative", (Object[])new Object[]{String.format(Locale.ENGLISH, "%+d", ((AdvancedFluidPumpMenu)this.menu).getTargetOffset().getX()), String.format(Locale.ENGLISH, "%+d", ((AdvancedFluidPumpMenu)this.menu).getTargetOffset().getY()), String.format(Locale.ENGLISH, "%+d", ((AdvancedFluidPumpMenu)this.menu).getTargetOffset().getZ())}) : Component.translatable((String)"tooltip.energizedpower.fluid_pump.target", (Object[])new Object[]{targetPos.getX(), targetPos.getY(), targetPos.getZ()});
        int componentWidth = this.font.width((FormattedText)component);
        guiGraphics.drawString(this.font, (Component)component, (int)((float)(x + 35) + (float)(162 - componentWidth) * 0.5f), y + 22, 0, false);
        if (((AdvancedFluidPumpMenu)this.menu).getSlot(36).getItem().isEmpty()) {
            component = Component.translatable((String)"tooltip.energizedpower.fluid_pump.cobblestone_missing").withStyle(ChatFormatting.RED);
            componentWidth = this.font.width((FormattedText)component);
            guiGraphics.drawString(this.font, (Component)component, (int)((float)(x + 35) + (float)(162 - componentWidth) * 0.5f), y + 58, 0, false);
        } else if (((AdvancedFluidPumpMenu)this.menu).isExtractingFluid() && !(targetFluidState = ((AdvancedFluidPumpBlockEntity)((AdvancedFluidPumpMenu)this.menu).getBlockEntity()).getLevel().getFluidState(targetPos)).isEmpty()) {
            component = Component.translatable((String)"tooltip.energizedpower.fluid_pump.extracting", (Object[])new Object[]{Component.translatable((String)new FluidStack(targetFluidState.getType(), 1).getDescriptionId())});
            componentWidth = this.font.width((FormattedText)component);
            guiGraphics.drawString(this.font, (Component)component, (int)((float)(x + 35) + (float)(162 - componentWidth) * 0.5f), y + 58, 0, false);
        }
    }

    @Override
    protected void renderTooltipNormalView(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltipNormalView(guiGraphics, mouseX, mouseY);
        for (int i = 0; i < 4; ++i) {
            if (!this.isHovering(206 + i % 2 * 18, 17 + i / 2 * 54, 16, 52, mouseX, mouseY)) continue;
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            boolean fluidEmpty = ((AdvancedFluidPumpMenu)this.menu).getFluid(i).isEmpty();
            int fluidAmount = fluidEmpty ? 0 : ((AdvancedFluidPumpMenu)this.menu).getFluid(i).getAmount();
            MutableComponent tooltipComponent = Component.translatable((String)"tooltip.energizedpower.fluid_meter.content_amount.txt", (Object[])new Object[]{FluidUtils.getFluidAmountWithPrefix(fluidAmount), FluidUtils.getFluidAmountWithPrefix(((AdvancedFluidPumpMenu)this.menu).getTankCapacity(i))});
            if (!fluidEmpty) {
                tooltipComponent = Component.translatable((String)((AdvancedFluidPumpMenu)this.menu).getFluid(i).getDescriptionId()).append(" ").append((Component)tooltipComponent);
            }
            components.add(tooltipComponent);
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

