/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.block.entity.AdvancedAutoCrafterBlockEntity;
import me.jddev0.ep.inventory.ItemCapabilityMenuHelper;
import me.jddev0.ep.inventory.PatternResultSlot;
import me.jddev0.ep.inventory.PatternSlot;
import me.jddev0.ep.inventory.UpgradeModuleSlot;
import me.jddev0.ep.inventory.data.SimpleBooleanValueContainerData;
import me.jddev0.ep.inventory.data.SimpleComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.SimpleEnergyValueContainerData;
import me.jddev0.ep.inventory.data.SimpleProgressValueContainerData;
import me.jddev0.ep.inventory.data.SimpleRedstoneModeValueContainerData;
import me.jddev0.ep.inventory.data.SimpleShortValueContainerData;
import me.jddev0.ep.inventory.upgrade.UpgradeModuleInventory;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.EPMenuTypes;
import me.jddev0.ep.screen.base.IConfigurableMenu;
import me.jddev0.ep.screen.base.IEnergyStorageConsumerIndicatorBarMenu;
import me.jddev0.ep.screen.base.UpgradableEnergyStorageMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.SlotItemHandler;

public class AdvancedAutoCrafterMenu
extends UpgradableEnergyStorageMenu<AdvancedAutoCrafterBlockEntity>
implements IEnergyStorageConsumerIndicatorBarMenu,
IConfigurableMenu {
    private final Container[] patternSlots;
    private final Container[] patternResultSlots;
    private final SimpleProgressValueContainerData[] progressData = new SimpleProgressValueContainerData[]{new SimpleProgressValueContainerData(), new SimpleProgressValueContainerData(), new SimpleProgressValueContainerData()};
    private final SimpleProgressValueContainerData[] maxProgressData = new SimpleProgressValueContainerData[]{new SimpleProgressValueContainerData(), new SimpleProgressValueContainerData(), new SimpleProgressValueContainerData()};
    private final SimpleEnergyValueContainerData energyConsumptionPerTickData = new SimpleEnergyValueContainerData();
    private final SimpleEnergyValueContainerData[] energyConsumptionLeftData = new SimpleEnergyValueContainerData[]{new SimpleEnergyValueContainerData(), new SimpleEnergyValueContainerData(), new SimpleEnergyValueContainerData()};
    private final SimpleBooleanValueContainerData[] hasEnoughEnergyData = new SimpleBooleanValueContainerData[]{new SimpleBooleanValueContainerData(), new SimpleBooleanValueContainerData(), new SimpleBooleanValueContainerData()};
    private final SimpleBooleanValueContainerData[] ignoreNBTData = new SimpleBooleanValueContainerData[]{new SimpleBooleanValueContainerData(), new SimpleBooleanValueContainerData(), new SimpleBooleanValueContainerData()};
    private final SimpleBooleanValueContainerData secondaryExtractModeData = new SimpleBooleanValueContainerData();
    private final SimpleBooleanValueContainerData allowOutputOverflowData = new SimpleBooleanValueContainerData();
    private final SimpleShortValueContainerData currentRecipeIndexData = new SimpleShortValueContainerData();
    private final SimpleRedstoneModeValueContainerData redstoneModeData = new SimpleRedstoneModeValueContainerData();
    private final SimpleComparatorModeValueContainerData comparatorModeData = new SimpleComparatorModeValueContainerData();

    public AdvancedAutoCrafterMenu(int id, Inventory inv, FriendlyByteBuf buffer) {
        this(id, inv, inv.player.level().getBlockEntity(buffer.readBlockPos()), new UpgradeModuleInventory(UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY), new Container[]{new SimpleContainer(9), new SimpleContainer(9), new SimpleContainer(9)}, new Container[]{new SimpleContainer(1), new SimpleContainer(1), new SimpleContainer(1)}, null);
    }

    public AdvancedAutoCrafterMenu(int id, Inventory inv, BlockEntity blockEntity, UpgradeModuleInventory upgradeModuleInventory, Container[] patternSlots, Container[] patternResultSlots, ContainerData data) {
        super(EPMenuTypes.ADVANCED_AUTO_CRAFTER_MENU.get(), id, inv, blockEntity, (Block)EPBlocks.ADVANCED_AUTO_CRAFTER.get(), 8, 142, upgradeModuleInventory, 3);
        this.patternSlots = patternSlots;
        this.patternResultSlots = patternResultSlots;
        ItemCapabilityMenuHelper.getCapabilityItemHandler(this.level, this.blockEntity).ifPresent(itemHandler -> {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.addSlot((Slot)new SlotItemHandler(itemHandler, 9 * i + j, 8 + 18 * j, 75 + 18 * i));
                }
            }
        });
        for (int ri = 0; ri < 3; ++ri) {
            final int recipeIndex = ri;
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    this.addSlot(new PatternSlot(patternSlots[recipeIndex], j + i * 3, 30 + j * 18, 17 + i * 18, () -> true){

                        public boolean isActive() {
                            return super.isActive() && !AdvancedAutoCrafterMenu.this.isInUpgradeModuleView() && AdvancedAutoCrafterMenu.this.getRecipeIndex() == recipeIndex;
                        }
                    });
                }
            }
            this.addSlot(new PatternResultSlot(patternResultSlots[recipeIndex], 0, 124, 35, () -> true){

                public boolean isActive() {
                    return super.isActive() && !AdvancedAutoCrafterMenu.this.isInUpgradeModuleView() && AdvancedAutoCrafterMenu.this.getRecipeIndex() == recipeIndex;
                }
            });
        }
        for (int i = 0; i < upgradeModuleInventory.getContainerSize(); ++i) {
            this.addSlot(new UpgradeModuleSlot((Container)upgradeModuleInventory, i, 62 + i * 18, 35, this::isInUpgradeModuleView));
        }
        if (data == null) {
            this.addDataSlots(this.progressData[0]);
            this.addDataSlots(this.progressData[1]);
            this.addDataSlots(this.progressData[2]);
            this.addDataSlots(this.maxProgressData[0]);
            this.addDataSlots(this.maxProgressData[1]);
            this.addDataSlots(this.maxProgressData[2]);
            this.addDataSlots(this.energyConsumptionPerTickData);
            this.addDataSlots(this.energyConsumptionLeftData[0]);
            this.addDataSlots(this.energyConsumptionLeftData[1]);
            this.addDataSlots(this.energyConsumptionLeftData[2]);
            this.addDataSlots(this.hasEnoughEnergyData[0]);
            this.addDataSlots(this.hasEnoughEnergyData[1]);
            this.addDataSlots(this.hasEnoughEnergyData[2]);
            this.addDataSlots(this.ignoreNBTData[0]);
            this.addDataSlots(this.ignoreNBTData[1]);
            this.addDataSlots(this.ignoreNBTData[2]);
            this.addDataSlots(this.secondaryExtractModeData);
            this.addDataSlots(this.allowOutputOverflowData);
            this.addDataSlots(this.currentRecipeIndexData);
            this.addDataSlots(this.redstoneModeData);
            this.addDataSlots(this.comparatorModeData);
        } else {
            this.addDataSlots(data);
        }
    }

    public Container[] getPatternSlots() {
        return this.patternSlots;
    }

    @Override
    public int getEnergyIndicatorBarValue() {
        int energyIndicatorBarValueSum = -1;
        for (SimpleEnergyValueContainerData ele : this.energyConsumptionLeftData) {
            int value = ele.getValue();
            if ((long)(energyIndicatorBarValueSum + value) != (long)energyIndicatorBarValueSum + (long)value) {
                return Integer.MAX_VALUE;
            }
            if (value <= -1) continue;
            if (energyIndicatorBarValueSum == -1) {
                ++energyIndicatorBarValueSum;
            }
            energyIndicatorBarValueSum += value;
        }
        return energyIndicatorBarValueSum;
    }

    @Override
    public int getEnergyPerTickBarValue() {
        return this.energyConsumptionPerTickData.getValue();
    }

    public boolean isCraftingActive() {
        int index = this.getRecipeIndex();
        return this.progressData[index].getValue() > 0;
    }

    public boolean isCrafting() {
        int index = this.getRecipeIndex();
        return this.progressData[index].getValue() > 0 && this.hasEnoughEnergyData[index].getValue();
    }

    public int getScaledProgressArrowSize() {
        int index = this.getRecipeIndex();
        int progress = this.progressData[index].getValue();
        int maxProgress = this.maxProgressData[index].getValue();
        int progressArrowSize = 24;
        return maxProgress == 0 || progress == 0 ? 0 : progress * progressArrowSize / maxProgress;
    }

    public boolean isIgnoreNBT() {
        int index = this.getRecipeIndex();
        return this.ignoreNBTData[index].getValue();
    }

    public boolean isSecondaryExtractMode() {
        return this.secondaryExtractModeData.getValue();
    }

    public boolean isAllowOutputOverflow() {
        return this.allowOutputOverflowData.getValue();
    }

    public int getRecipeIndex() {
        return this.currentRecipeIndexData.getValue();
    }

    @Override
    public RedstoneMode getRedstoneMode() {
        return this.redstoneModeData.getValue();
    }

    @Override
    public ComparatorMode getComparatorMode() {
        return this.comparatorModeData.getValue();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceItem = sourceSlot.getItem();
        ItemStack sourceItemCopy = sourceItem.copy();
        if (index < 36) {
            if (!this.moveItemStackTo(sourceItem, 93, 96, false) && !this.moveItemStackTo(sourceItem, 41, 63, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 63) {
            if (!this.moveItemStackTo(sourceItem, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            if (index < 93) {
                return ItemStack.EMPTY;
            }
            if (index < 96) {
                if (!this.moveItemStackTo(sourceItem, 0, 36, false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                throw new IllegalArgumentException("Invalid slot index");
            }
        }
        if (sourceItem.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(player, sourceItem);
        return sourceItemCopy;
    }
}

