/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.codec.CodecFix;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PressMoldMakerRecipe
implements Recipe<RecipeInput> {
    private final ItemStack output;
    private final int clayCount;

    public PressMoldMakerRecipe(ItemStack output, int clayCount) {
        this.output = output;
        this.clayCount = clayCount;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public int getClayCount() {
        return this.clayCount;
    }

    public boolean matches(RecipeInput container, Level level) {
        if (level.isClientSide) {
            return false;
        }
        ItemStack item = container.getItem(0);
        return item.is(Items.CLAY_BALL) && item.getCount() >= this.clayCount;
    }

    public ItemStack assemble(RecipeInput container, HolderLookup.Provider registries) {
        return this.output;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.output.copy();
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)EPBlocks.PRESS_MOLD_MAKER_ITEM.get());
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<PressMoldMakerRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = EPAPI.id("press_mold_maker");
        private final MapCodec<PressMoldMakerRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CodecFix.ITEM_STACK_CODEC.fieldOf("output").forGetter(recipe -> recipe.output), (App)ExtraCodecs.POSITIVE_INT.fieldOf("clayCount").forGetter(recipe -> recipe.clayCount)).apply((Applicative)instance, PressMoldMakerRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, PressMoldMakerRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        private Serializer() {
        }

        public MapCodec<PressMoldMakerRecipe> codec() {
            return this.CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PressMoldMakerRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static PressMoldMakerRecipe read(RegistryFriendlyByteBuf buffer) {
            int clayCount = buffer.readInt();
            ItemStack output = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            return new PressMoldMakerRecipe(output, clayCount);
        }

        private static void write(RegistryFriendlyByteBuf buffer, PressMoldMakerRecipe recipe) {
            buffer.writeInt(recipe.clayCount);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
        }
    }

    public static final class Type
    implements RecipeType<PressMoldMakerRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "press_mold_maker";

        private Type() {
        }
    }
}

