/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.handler.codec.DecoderException;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public record IngredientWithCount(Ingredient input, int count) {
    public static final IngredientWithCount EMPTY = new IngredientWithCount(Ingredient.EMPTY, 0);
    public static final Codec<IngredientWithCount> CODEC_NONEMPTY = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("input").forGetter(input -> input.input), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("count", (Object)1).forGetter(input -> input.count)).apply((Applicative)instance, IngredientWithCount::new));
    public static final Codec<IngredientWithCount> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.CODEC.fieldOf("input").forGetter(input -> input.input), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(input -> input.count)).apply((Applicative)instance, IngredientWithCount::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, IngredientWithCount> OPTIONAL_STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, IngredientWithCount>(){

        @NotNull
        public IngredientWithCount decode(@NotNull RegistryFriendlyByteBuf buffer) {
            int count = buffer.readInt();
            if (count <= 0) {
                return EMPTY;
            }
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            return new IngredientWithCount(input, count);
        }

        public void encode(@NotNull RegistryFriendlyByteBuf buffer, IngredientWithCount ingredient) {
            if (ingredient.isEmpty()) {
                buffer.writeInt(0);
            } else {
                buffer.writeInt(ingredient.count);
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient.input);
            }
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, IngredientWithCount> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, IngredientWithCount>(){

        @NotNull
        public IngredientWithCount decode(@NotNull RegistryFriendlyByteBuf buffer) {
            IngredientWithCount ingredient = (IngredientWithCount)OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            if (ingredient.isEmpty()) {
                throw new DecoderException("Empty IngredientWithCount not allowed");
            }
            return ingredient;
        }

        public void encode(@NotNull RegistryFriendlyByteBuf buffer, IngredientWithCount ingredient) {
            if (ingredient.isEmpty()) {
                throw new DecoderException("Empty IngredientWithCount not allowed");
            }
            OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
        }
    };

    public IngredientWithCount(Ingredient input) {
        this(input, 1);
    }

    public boolean isEmpty() {
        return this.input.isEmpty() || this.count <= 0;
    }
}

