/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.networking.packet;

import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.entity.TimeControllerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record SetTimeFromTimeControllerC2SPacket(BlockPos pos, int time) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetTimeFromTimeControllerC2SPacket> ID = new CustomPacketPayload.Type(EPAPI.id("set_time_from_time_controller"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SetTimeFromTimeControllerC2SPacket> STREAM_CODEC = StreamCodec.ofMember(SetTimeFromTimeControllerC2SPacket::write, SetTimeFromTimeControllerC2SPacket::new);

    public SetTimeFromTimeControllerC2SPacket(RegistryFriendlyByteBuf buffer) {
        this(buffer.readBlockPos(), buffer.readInt());
    }

    public void write(RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeInt(this.time);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static void handle(SetTimeFromTimeControllerC2SPacket data, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt1$temp;
            ServerLevel level;
            block11: {
                block10: {
                    Level patt0$temp = context.player().level();
                    if (!(patt0$temp instanceof ServerLevel)) break block10;
                    level = (ServerLevel)patt0$temp;
                    patt1$temp = context.player();
                    if (patt1$temp instanceof ServerPlayer) break block11;
                }
                return;
            }
            ServerPlayer player = (ServerPlayer)patt1$temp;
            if (!level.hasChunk(SectionPos.blockToSectionCoord((int)data.pos.getX()), SectionPos.blockToSectionCoord((int)data.pos.getZ()))) {
                return;
            }
            BlockEntity blockEntity = level.getBlockEntity(data.pos);
            if (!(blockEntity instanceof TimeControllerBlockEntity)) {
                return;
            }
            TimeControllerBlockEntity timeControllerBlockEntity = (TimeControllerBlockEntity)blockEntity;
            IEnergyStorage energyStorage = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, data.pos, level.getBlockState(data.pos), (BlockEntity)timeControllerBlockEntity, null);
            if (energyStorage == null) {
                return;
            }
            if (energyStorage.getEnergyStored() < TimeControllerBlockEntity.CAPACITY) {
                return;
            }
            timeControllerBlockEntity.clearEnergy();
            if (data.time < 0 || data.time > 24000) {
                return;
            }
            long currentTime = level.getDayTime();
            int currentDayTime = (int)(currentTime % 24000L);
            if (currentDayTime <= data.time) {
                level.setDayTime(currentTime - (long)currentDayTime + (long)data.time);
            } else {
                level.setDayTime(currentTime + 24000L - (long)currentDayTime + (long)data.time);
            }
        });
    }
}

