/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.networking.packet;

import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.machine.CheckboxUpdate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record SetCheckboxC2SPacket(BlockPos pos, int checkboxId, boolean checked) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetCheckboxC2SPacket> ID = new CustomPacketPayload.Type(EPAPI.id("set_checkbox"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SetCheckboxC2SPacket> STREAM_CODEC = StreamCodec.ofMember(SetCheckboxC2SPacket::write, SetCheckboxC2SPacket::new);

    public SetCheckboxC2SPacket(RegistryFriendlyByteBuf buffer) {
        this(buffer.readBlockPos(), buffer.readInt(), buffer.readBoolean());
    }

    public void write(RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeInt(this.checkboxId);
        buffer.writeBoolean(this.checked);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static void handle(SetCheckboxC2SPacket data, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt1$temp;
            ServerLevel level;
            block6: {
                block5: {
                    Level patt0$temp = context.player().level();
                    if (!(patt0$temp instanceof ServerLevel)) break block5;
                    level = (ServerLevel)patt0$temp;
                    patt1$temp = context.player();
                    if (patt1$temp instanceof ServerPlayer) break block6;
                }
                return;
            }
            ServerPlayer player = (ServerPlayer)patt1$temp;
            if (!level.hasChunk(SectionPos.blockToSectionCoord((int)data.pos.getX()), SectionPos.blockToSectionCoord((int)data.pos.getZ()))) {
                return;
            }
            BlockEntity blockEntity = level.getBlockEntity(data.pos);
            if (!(blockEntity instanceof CheckboxUpdate)) {
                return;
            }
            CheckboxUpdate checkboxUpdate = (CheckboxUpdate)blockEntity;
            checkboxUpdate.setCheckbox(data.checkboxId, data.checked);
        });
    }
}

