/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.networking.packet;

import me.jddev0.ep.api.EPAPI;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PopEnergizedPowerBookFromLecternC2SPacket(BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PopEnergizedPowerBookFromLecternC2SPacket> ID = new CustomPacketPayload.Type(EPAPI.id("pop_energized_power_book_from_lectern"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PopEnergizedPowerBookFromLecternC2SPacket> STREAM_CODEC = StreamCodec.ofMember(PopEnergizedPowerBookFromLecternC2SPacket::write, PopEnergizedPowerBookFromLecternC2SPacket::new);

    public PopEnergizedPowerBookFromLecternC2SPacket(RegistryFriendlyByteBuf buffer) {
        this(buffer.readBlockPos());
    }

    public void write(RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static void handle(PopEnergizedPowerBookFromLecternC2SPacket data, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt1$temp;
            ServerLevel level;
            block8: {
                block7: {
                    Level patt0$temp = context.player().level();
                    if (!(patt0$temp instanceof ServerLevel)) break block7;
                    level = (ServerLevel)patt0$temp;
                    patt1$temp = context.player();
                    if (patt1$temp instanceof ServerPlayer) break block8;
                }
                return;
            }
            ServerPlayer player = (ServerPlayer)patt1$temp;
            if (!player.mayBuild()) {
                return;
            }
            if (!level.hasChunk(SectionPos.blockToSectionCoord((int)data.pos.getX()), SectionPos.blockToSectionCoord((int)data.pos.getZ()))) {
                return;
            }
            BlockEntity blockEntity = level.getBlockEntity(data.pos);
            if (!(blockEntity instanceof LecternBlockEntity)) {
                return;
            }
            LecternBlockEntity lecternBlockEntity = (LecternBlockEntity)blockEntity;
            ItemStack itemStack = lecternBlockEntity.getBook();
            lecternBlockEntity.setBook(ItemStack.EMPTY);
            LecternBlock.resetBookState((Entity)player, (Level)player.level(), (BlockPos)data.pos, (BlockState)player.level().getBlockState(data.pos), (boolean)false);
            if (!player.getInventory().add(itemStack)) {
                player.drop(itemStack, false);
            }
        });
    }
}

