/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item.energy;

import me.jddev0.ep.component.EPDataComponentTypes;
import me.jddev0.ep.energy.IEnergizedPowerEnergyStorage;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class ItemCapabilityEnergy
implements IEnergyStorage {
    private final ItemStack itemStack;
    private final IEnergizedPowerEnergyStorage energyStorage;

    public ItemCapabilityEnergy(ItemStack itemStack, IEnergizedPowerEnergyStorage energyStorage) {
        this.itemStack = itemStack;
        this.energyStorage = energyStorage;
        if (itemStack.has(EPDataComponentTypes.ENERGY)) {
            this.energyStorage.loadNBT((Tag)IntTag.valueOf((int)((Integer)itemStack.getOrDefault(EPDataComponentTypes.ENERGY, (Object)0))));
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        Tag nbt;
        int ret = this.energyStorage.receiveEnergy(maxReceive, simulate);
        if (!simulate && (nbt = this.energyStorage.saveNBT()) instanceof IntTag) {
            IntTag nbtInt = (IntTag)nbt;
            this.itemStack.set(EPDataComponentTypes.ENERGY, (Object)nbtInt.getAsInt());
        }
        return ret;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        Tag nbt;
        int ret = this.energyStorage.extractEnergy(maxExtract, simulate);
        if (!simulate && (nbt = this.energyStorage.saveNBT()) instanceof IntTag) {
            IntTag nbtInt = (IntTag)nbt;
            this.itemStack.set(EPDataComponentTypes.ENERGY, (Object)nbtInt.getAsInt());
        }
        return ret;
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.energyStorage.canExtract();
    }

    public boolean canReceive() {
        return this.energyStorage.canReceive();
    }

    public void setEnergy(int energy) {
        this.energyStorage.setEnergy(energy);
        Tag nbt = this.energyStorage.saveNBT();
        if (nbt instanceof IntTag) {
            IntTag nbtInt = (IntTag)nbt;
            this.itemStack.set(EPDataComponentTypes.ENERGY, (Object)nbtInt.getAsInt());
        }
    }

    public void setCapacity(int capacity) {
        this.energyStorage.setCapacity(capacity);
    }

    public IEnergizedPowerEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }
}

