/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item.energy;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import me.jddev0.ep.energy.IEnergizedPowerEnergyStorage;
import me.jddev0.ep.item.energy.ItemCapabilityEnergy;
import me.jddev0.ep.util.EnergyUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergizedPowerEnergyItem
extends Item {
    private final Function<ItemStack, IEnergizedPowerEnergyStorage> energyStorageProvider;

    protected static int getEnergy(ItemStack itemStack) {
        IEnergyStorage energyStorage = (IEnergyStorage)itemStack.getCapability(Capabilities.EnergyStorage.ITEM);
        return energyStorage instanceof ItemCapabilityEnergy ? energyStorage.getEnergyStored() : 0;
    }

    protected static void setEnergy(ItemStack itemStack, int energy) {
        IEnergyStorage energyStorage = (IEnergyStorage)itemStack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage instanceof ItemCapabilityEnergy) {
            ItemCapabilityEnergy energizedPowerEnergyStorage = (ItemCapabilityEnergy)energyStorage;
            energizedPowerEnergyStorage.setEnergy(energy);
        }
    }

    protected static int getCapacity(ItemStack itemStack) {
        IEnergyStorage energyStorage = (IEnergyStorage)itemStack.getCapability(Capabilities.EnergyStorage.ITEM);
        return energyStorage instanceof ItemCapabilityEnergy ? energyStorage.getMaxEnergyStored() : 0;
    }

    public EnergizedPowerEnergyItem(Item.Properties props, Supplier<IEnergizedPowerEnergyStorage> energyStorageProvider) {
        this(props, (ItemStack stack) -> (IEnergizedPowerEnergyStorage)energyStorageProvider.get());
    }

    public EnergizedPowerEnergyItem(Item.Properties props, Function<ItemStack, IEnergizedPowerEnergyStorage> energyStorageProvider) {
        super(props);
        this.energyStorageProvider = energyStorageProvider;
    }

    public Function<ItemStack, IEnergizedPowerEnergyStorage> getEnergyStorageProvider() {
        return this.energyStorageProvider;
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round((float)EnergizedPowerEnergyItem.getEnergy(stack) * 13.0f / (float)EnergizedPowerEnergyItem.getCapacity(stack));
    }

    public int getBarColor(ItemStack stack) {
        float f = Math.max(0.0f, (float)EnergizedPowerEnergyItem.getEnergy(stack) / (float)EnergizedPowerEnergyItem.getCapacity(stack));
        return Mth.hsvToRgb((float)(f * 0.33f), (float)1.0f, (float)1.0f);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        components.add((Component)Component.translatable((String)"tooltip.energizedpower.energy_meter.content.txt", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(EnergizedPowerEnergyItem.getEnergy(itemStack)), EnergyUtils.getEnergyWithPrefix(EnergizedPowerEnergyItem.getCapacity(itemStack))}).withStyle(ChatFormatting.GRAY));
    }
}

