/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item;

import java.util.ArrayList;
import java.util.List;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.item.energy.EnergizedPowerEnergyItem;
import me.jddev0.ep.util.EnergyUtils;
import me.jddev0.ep.util.FluidUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class FluidAnalyzerItem
extends EnergizedPowerEnergyItem {
    public static final int ENERGY_CONSUMPTION_PER_USE = ModConfigs.COMMON_FLUID_ANALYZER_ENERGY_CONSUMPTION_PER_USE.getValue();
    public static final int ENERGY_CAPACITY = ModConfigs.COMMON_FLUID_ANALYZER_CAPACITY.getValue();

    public FluidAnalyzerItem(Item.Properties props) {
        super(props, () -> new ReceiveOnlyEnergyStorage(0, ENERGY_CAPACITY, ModConfigs.COMMON_FLUID_ANALYZER_TRANSFER_RATE.getValue()));
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, context, components, tooltipFlag);
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.fluid_analyzer.txt.shift.1").withStyle(ChatFormatting.GRAY));
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.fluid_analyzer.txt.shift.2", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(ENERGY_CONSUMPTION_PER_USE)}).withStyle(ChatFormatting.GRAY));
        } else {
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.shift_details.txt").withStyle(ChatFormatting.YELLOW));
        }
    }

    private void useItem(ItemStack itemStack, Player player, List<Component> lines) {
        if (FluidAnalyzerItem.getEnergy(itemStack) >= ENERGY_CONSUMPTION_PER_USE) {
            FluidAnalyzerItem.setEnergy(itemStack, FluidAnalyzerItem.getEnergy(itemStack) - ENERGY_CONSUMPTION_PER_USE);
        }
        for (Component component : lines) {
            player.sendSystemMessage(component);
        }
        player.sendSystemMessage((Component)Component.empty());
    }

    private void addOutputTextForFluidStorage(List<Component> components, @Nullable IFluidHandler fluidStorage, boolean blockFaceSpecificInformation) {
        if (fluidStorage == null) {
            components.add((Component)Component.translatable((String)("txt.energizedpower.fluid_analyzer.no_fluid_block" + (blockFaceSpecificInformation ? "_side" : ""))).withStyle(ChatFormatting.RED));
            return;
        }
        components.add((Component)Component.translatable((String)("txt.energizedpower.fluid_analyzer.fluid_output.tank_count" + (blockFaceSpecificInformation ? "_side" : "")), (Object[])new Object[]{fluidStorage.getTanks()}).withStyle(ChatFormatting.BLUE));
        for (int i = 0; i < fluidStorage.getTanks(); ++i) {
            boolean fluidEmpty = fluidStorage.getFluidInTank(i).isEmpty();
            int fluidAmount = fluidEmpty ? 0 : fluidStorage.getFluidInTank(i).getAmount();
            components.add((Component)Component.literal((String)"\u2022 ").append((Component)Component.translatable((String)"txt.energizedpower.fluid_analyzer.fluid_output.tank_fluid_content", (Object[])new Object[]{i + 1, fluidEmpty ? "" : Component.translatable((String)fluidStorage.getFluidInTank(i).getDescriptionId()).append(" "), FluidUtils.getFluidAmountWithPrefix(fluidAmount), FluidUtils.getFluidAmountWithPrefix(fluidStorage.getTankCapacity(i))})).withStyle(ChatFormatting.BLUE));
        }
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext useOnContext) {
        Level level = useOnContext.getLevel();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (FluidAnalyzerItem.getEnergy(stack) < ENERGY_CONSUMPTION_PER_USE) {
            this.useItem(stack, useOnContext.getPlayer(), List.of(Component.translatable((String)"txt.energizedpower.fluid_analyzer.no_energy_left", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(ENERGY_CONSUMPTION_PER_USE)}).withStyle(ChatFormatting.RED)));
            return InteractionResult.SUCCESS;
        }
        BlockPos blockPos = useOnContext.getClickedPos();
        ArrayList<Component> components = new ArrayList<Component>();
        components.add((Component)level.getBlockState(blockPos).getBlock().getName().withStyle(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.AQUA}));
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        IFluidHandler fluidStorage = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, blockPos, level.getBlockState(blockPos), blockEntity, null);
        this.addOutputTextForFluidStorage(components, fluidStorage, false);
        components.add((Component)Component.translatable((String)"txt.energizedpower.fluid_analyzer.output_side_information").withStyle(ChatFormatting.GOLD));
        IFluidHandler fluidStorageSided = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, blockPos, level.getBlockState(blockPos), blockEntity, (Object)useOnContext.getClickedFace());
        this.addOutputTextForFluidStorage(components, fluidStorageSided, true);
        this.useItem(stack, useOnContext.getPlayer(), components);
        return InteractionResult.SUCCESS;
    }
}

