/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item;

import me.jddev0.ep.block.CableBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.block.state.BlockState;

public class CutterItem
extends TieredItem {
    private final RandomSource random = RandomSource.create();

    public CutterItem(Tier tier, Item.Properties props) {
        super(tier, props.setNoRepair());
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        ItemStack copy = itemStack.copy();
        if (copy.isDamageableItem()) {
            int i = copy.getDamageValue() + 1;
            copy.setDamageValue(i);
            if (i >= copy.getMaxDamage()) {
                copy.setCount(0);
            }
        }
        return copy;
    }

    public boolean hasCraftingRemainingItem(ItemStack itemStack) {
        return true;
    }

    public float getDestroySpeed(ItemStack itemStack, BlockState blockState) {
        if (blockState.getBlock() instanceof CableBlock) {
            return 15.0f;
        }
        return super.getDestroySpeed(itemStack, blockState);
    }
}

