/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item;

import java.util.List;
import me.jddev0.ep.energy.ReceiveAndExtractEnergyStorage;
import me.jddev0.ep.item.energy.EnergizedPowerEnergyItem;
import me.jddev0.ep.machine.tier.BatteryTier;
import me.jddev0.ep.util.EnergyUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class BatteryItem
extends EnergizedPowerEnergyItem {
    private final BatteryTier tier;

    public BatteryItem(BatteryTier tier) {
        super(new Item.Properties().stacksTo(1), () -> new ReceiveAndExtractEnergyStorage(0, tier.getCapacity(), tier.getMaxTransfer()));
        this.tier = tier;
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, context, components, tooltipFlag);
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.battery.txt.shift.1", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(this.tier.getMaxTransfer())}).withStyle(ChatFormatting.GRAY));
        } else {
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.shift_details.txt").withStyle(ChatFormatting.YELLOW));
        }
    }
}

