/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.inventory.upgrade;

import me.jddev0.ep.item.upgrade.UpgradeModuleItem;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class UpgradeModuleInventory
extends SimpleContainer {
    private final UpgradeModuleModifier[] upgradeModifierSlots;

    public UpgradeModuleInventory(UpgradeModuleModifier ... upgradeModifierSlots) {
        super(upgradeModifierSlots.length);
        this.upgradeModifierSlots = upgradeModifierSlots;
    }

    public UpgradeModuleModifier[] getUpgradeModifierSlots() {
        return this.upgradeModifierSlots;
    }

    public boolean canPlaceItem(int slot, @NotNull ItemStack stack) {
        if (slot >= 0 && slot < this.getContainerSize()) {
            UpgradeModuleItem upgradeModuleItem;
            Item item = stack.getItem();
            return item instanceof UpgradeModuleItem && (upgradeModuleItem = (UpgradeModuleItem)item).getMainUpgradeModuleModifier() == this.upgradeModifierSlots[slot];
        }
        return false;
    }

    public int getMaxStackSize() {
        return 1;
    }

    public int getUpgradeModuleTier(int slot) {
        ItemStack itemStack = this.getItem(slot);
        Item item = itemStack.getItem();
        if (!(item instanceof UpgradeModuleItem)) {
            return -1;
        }
        UpgradeModuleItem upgradeModuleItem = (UpgradeModuleItem)item;
        return upgradeModuleItem.getUpgradeModuleTier();
    }

    public UpgradeModuleModifier[] getUpgradeModuleModifiers(int slot) {
        ItemStack itemStack = this.getItem(slot);
        Item item = itemStack.getItem();
        if (!(item instanceof UpgradeModuleItem)) {
            return new UpgradeModuleModifier[0];
        }
        UpgradeModuleItem upgradeModuleItem = (UpgradeModuleItem)item;
        return upgradeModuleItem.getUpgradeModuleModifiers();
    }

    public double getUpgradeModuleModifierEffect(int slot, UpgradeModuleModifier modifier) {
        ItemStack itemStack = this.getItem(slot);
        Item item = itemStack.getItem();
        if (!(item instanceof UpgradeModuleItem)) {
            return -1.0;
        }
        UpgradeModuleItem upgradeModuleItem = (UpgradeModuleItem)item;
        return upgradeModuleItem.getUpgradeModuleModifierValue(modifier);
    }

    public double getModifierEffectProduct(UpgradeModuleModifier modifier) {
        double prod = 1.0;
        for (int i = 0; i < this.getContainerSize(); ++i) {
            double value = this.getUpgradeModuleModifierEffect(i, modifier);
            if (value == -1.0) continue;
            prod *= value;
        }
        return prod;
    }

    public double getModifierEffectSum(UpgradeModuleModifier modifier) {
        double sum = 0.0;
        for (int i = 0; i < this.getContainerSize(); ++i) {
            double value = this.getUpgradeModuleModifierEffect(i, modifier);
            if (value == -1.0) continue;
            sum += value;
        }
        return sum;
    }

    public Tag saveToNBT(HolderLookup.Provider registries) {
        NonNullList items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.getContainerSize(); ++i) {
            items.set(i, (Object)this.getItem(i));
        }
        return ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), (NonNullList)items, (HolderLookup.Provider)registries);
    }

    public void loadFromNBT(CompoundTag tag, HolderLookup.Provider registries) {
        NonNullList items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)items, (HolderLookup.Provider)registries);
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.setItem(i, (ItemStack)items.get(i));
        }
    }
}

