/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.inventory;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public class InfiniteSingleItemStackHandler
extends ItemStackHandler {
    protected ItemStack stack = ItemStack.EMPTY;

    public void setSize(int size) {
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        this.stack = stack.copyWithCount(1);
        this.onContentsChanged(slot);
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStack() {
        return this.stack.copy();
    }

    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        if (this.stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return this.stack.copyWithCount(this.stack.getMaxStackSize());
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.validateSlotIndex(slot);
        return ItemStack.EMPTY;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        this.validateSlotIndex(slot);
        if (this.stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return this.stack.copyWithCount(Math.min(amount, this.stack.getMaxStackSize()));
    }

    public final int getSlotLimit(int slot) {
        return 99;
    }

    protected final int getStackLimit(int slot, ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.getMaxStackSize());
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
        CompoundTag nbt = new CompoundTag();
        if (!this.stack.isEmpty()) {
            nbt.put("Item", this.stack.save(lookupProvider, (Tag)new CompoundTag()));
            nbt.getCompound("Item").remove("count");
        }
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
        if (nbt.contains("Item")) {
            CompoundTag itemNbt = nbt.getCompound("Item");
            itemNbt.putInt("count", 1);
            this.stack = ItemStack.parse((HolderLookup.Provider)lookupProvider, (Tag)itemNbt).orElse(ItemStack.EMPTY).copyWithCount(1);
        } else {
            this.stack = ItemStack.EMPTY;
        }
    }

    protected void validateSlotIndex(int slot) {
        if (slot != 0) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0,1)");
        }
    }
}

