/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.inventory;

import java.util.Optional;
import me.jddev0.ep.inventory.InfiniteSingleItemStackHandler;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CreativeItemSiloSlot
extends Slot {
    private static final Container EMPTY_INVENTORY = new SimpleContainer(0);
    private final InfiniteSingleItemStackHandler itemHandler;
    protected final int index;

    public CreativeItemSiloSlot(InfiniteSingleItemStackHandler itemHandler, int index, int x, int y) {
        super(EMPTY_INVENTORY, index, x, y);
        this.itemHandler = itemHandler;
        this.index = index;
    }

    protected void onQuickCraft(ItemStack itemStack, int amount) {
    }

    public boolean mayPlace(ItemStack itemStack) {
        return false;
    }

    public ItemStack getItem() {
        return this.getItemHandler().getStack();
    }

    public void set(ItemStack stack) {
        this.itemHandler.setStackInSlot(this.index, stack);
        this.setChanged();
    }

    public boolean mayPickup(Player player) {
        return true;
    }

    public ItemStack safeInsert(ItemStack itemStack, int amount) {
        if (!itemStack.isEmpty()) {
            ItemStack selfItem = this.getItem();
            if (selfItem.isEmpty() || !ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)selfItem) || !ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)selfItem)) {
                this.set(itemStack.copyWithCount(1));
            } else {
                selfItem.grow(1);
                this.set(selfItem);
            }
        }
        return itemStack;
    }

    public Optional<ItemStack> tryRemove(int count, int limit, Player player) {
        ItemStack selfItem = this.getItem();
        if (!selfItem.isEmpty()) {
            selfItem.shrink(1);
            this.set(selfItem);
        }
        return Optional.empty();
    }

    public boolean isFake() {
        return true;
    }

    public InfiniteSingleItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSameInventory(Slot other) {
        if (!(other instanceof CreativeItemSiloSlot)) return false;
        CreativeItemSiloSlot that = (CreativeItemSiloSlot)other;
        if (that.itemHandler != this.itemHandler) return false;
        return true;
    }
}

