/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.block.entity.PlantGrowthChamberBlockEntity;
import me.jddev0.ep.recipe.OutputItemStackWithPercentages;
import me.jddev0.ep.recipe.PlantGrowthChamberRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public class PlantGrowthChamberCategory
implements IRecipeCategory<RecipeHolder<PlantGrowthChamberRecipe>> {
    public static final RecipeType<RecipeHolder<PlantGrowthChamberRecipe>> TYPE = RecipeType.createFromVanilla((net.minecraft.world.item.crafting.RecipeType)PlantGrowthChamberRecipe.Type.INSTANCE);
    private final IDrawable background;
    private final IDrawable icon;

    public PlantGrowthChamberCategory(IGuiHelper helper) {
        ResourceLocation texture = EPAPI.id("textures/gui/container/plant_growth_chamber.png");
        this.background = helper.createDrawable(texture, 61, 25, 108, 48);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)EPBlocks.PLANT_GROWTH_CHAMBER_ITEM.get()));
    }

    public RecipeType<RecipeHolder<PlantGrowthChamberRecipe>> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"container.energizedpower.plant_growth_chamber");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder iRecipeLayout, RecipeHolder<PlantGrowthChamberRecipe> recipe, IFocusGroup iFocusGroup) {
        iRecipeLayout.addSlot(RecipeIngredientRole.INPUT, 1, 10).addIngredients(((PlantGrowthChamberRecipe)recipe.value()).getInput());
        ArrayList outputSlotEntries = new ArrayList(4);
        for (int i = 0; i < 4; ++i) {
            outputSlotEntries.add(new ArrayList());
        }
        ItemStack[] outputEntries = ((PlantGrowthChamberRecipe)recipe.value()).getMaxOutputCounts();
        for (int i = 0; i < outputEntries.length; ++i) {
            ((List)outputSlotEntries.get(i % 4)).add(outputEntries[i]);
        }
        IRecipeSlotRichTooltipCallback callback = (view, tooltip) -> {
            if (view.isEmpty()) {
                return;
            }
            Optional optionalItemStack = view.getDisplayedItemStack();
            if (optionalItemStack.isEmpty()) {
                return;
            }
            tooltip.add((FormattedText)Component.translatable((String)"recipes.energizedpower.transfer.output_percentages"));
            OutputItemStackWithPercentages[] outputs = ((PlantGrowthChamberRecipe)recipe.value()).getOutputs();
            for (int i = 0; i < outputs.length; ++i) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)((ItemStack)optionalItemStack.get()), (ItemStack)outputs[i].output())) continue;
                double[] percentages = outputs[i].percentages();
                for (int j = 0; j < percentages.length; ++j) {
                    tooltip.add((FormattedText)Component.literal((String)String.format(Locale.ENGLISH, "%2d \u2022 %.2f %%", j + 1, 100.0 * percentages[j])));
                }
                return;
            }
        };
        ((IRecipeSlotBuilder)iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 73, 1).addItemStacks((List)outputSlotEntries.get(0))).addRichTooltipCallback(callback);
        ((IRecipeSlotBuilder)iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 91, 1).addItemStacks((List)outputSlotEntries.get(1))).addRichTooltipCallback(callback);
        ((IRecipeSlotBuilder)iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 73, 19).addItemStacks((List)outputSlotEntries.get(2))).addRichTooltipCallback(callback);
        ((IRecipeSlotBuilder)iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 91, 19).addItemStacks((List)outputSlotEntries.get(3))).addRichTooltipCallback(callback);
    }

    public void draw(RecipeHolder<PlantGrowthChamberRecipe> recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Font font = Minecraft.getInstance().font;
        int ticks = (int)((float)((PlantGrowthChamberRecipe)recipe.value()).getTicks() * PlantGrowthChamberBlockEntity.RECIPE_DURATION_MULTIPLIER);
        MutableComponent component = Component.translatable((String)"recipes.energizedpower.info.ticks", (Object[])new Object[]{ticks});
        int textWidth = font.width((FormattedText)component);
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)component, 108 - textWidth, 40, -1, false);
    }
}

