/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.jddev0.ep.block.entity.AutoCrafterBlockEntity;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.SetAutoCrafterPatternInputSlotsC2SPacket;
import me.jddev0.ep.screen.AutoCrafterMenu;
import me.jddev0.ep.screen.EPMenuTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;

public class AutoCrafterTransferHandler
implements IRecipeTransferHandler<AutoCrafterMenu, RecipeHolder<CraftingRecipe>> {
    private final IRecipeTransferHandlerHelper helper;

    public AutoCrafterTransferHandler(IRecipeTransferHandlerHelper helper) {
        this.helper = helper;
    }

    public Class<? extends AutoCrafterMenu> getContainerClass() {
        return AutoCrafterMenu.class;
    }

    public Optional<MenuType<AutoCrafterMenu>> getMenuType() {
        return Optional.of(EPMenuTypes.AUTO_CRAFTER_MENU.get());
    }

    public RecipeType<RecipeHolder<CraftingRecipe>> getRecipeType() {
        return null;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(AutoCrafterMenu container, RecipeHolder<CraftingRecipe> recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        if (!((CraftingRecipe)recipe.value()).canCraftInDimensions(3, 3)) {
            return this.helper.createUserErrorWithTooltip((Component)Component.translatable((String)"recipes.energizedpower.transfer.too_large"));
        }
        if (!doTransfer) {
            return null;
        }
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>(9);
        List inputSlots = recipeSlots.getSlotViews(RecipeIngredientRole.INPUT);
        int len = Math.min(inputSlots.size(), 9);
        for (int i = 0; i < len; ++i) {
            itemStacks.add(((IRecipeSlotView)inputSlots.get(i)).getDisplayedItemStack().orElse(ItemStack.EMPTY).copy());
        }
        ModMessages.sendToServer(new SetAutoCrafterPatternInputSlotsC2SPacket(((AutoCrafterBlockEntity)container.getBlockEntity()).getBlockPos(), itemStacks, recipe.id()));
        return null;
    }
}

