/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.jei;

import java.util.Arrays;
import java.util.stream.Collectors;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.recipe.AssemblingMachineRecipe;
import me.jddev0.ep.recipe.IngredientWithCount;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public class AssemblingMachineCategory
implements IRecipeCategory<RecipeHolder<AssemblingMachineRecipe>> {
    public static final RecipeType<RecipeHolder<AssemblingMachineRecipe>> TYPE = RecipeType.createFromVanilla((net.minecraft.world.item.crafting.RecipeType)AssemblingMachineRecipe.Type.INSTANCE);
    private final IDrawable background;
    private final IDrawable icon;

    public AssemblingMachineCategory(IGuiHelper helper) {
        ResourceLocation texture = EPAPI.id("textures/gui/container/assembling_machine.png");
        this.background = helper.createDrawable(texture, 43, 18, 115, 54);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)EPBlocks.ASSEMBLING_MACHINE_ITEM.get()));
    }

    public RecipeType<RecipeHolder<AssemblingMachineRecipe>> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"container.energizedpower.assembling_machine");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder iRecipeLayoutBuilder, RecipeHolder<AssemblingMachineRecipe> recipe, IFocusGroup iFocusGroup) {
        int len = Math.min(((AssemblingMachineRecipe)recipe.value()).getInputs().length, 4);
        for (int i = 0; i < len; ++i) {
            IngredientWithCount input = ((AssemblingMachineRecipe)recipe.value()).getInputs()[i];
            iRecipeLayoutBuilder.addSlot(RecipeIngredientRole.INPUT, i == 1 ? 1 : (i == 2 ? 37 : 19), i == 0 ? 1 : (i == 3 ? 37 : 19)).addItemStacks(Arrays.stream(input.input().getItems()).map(itemStack -> itemStack.copyWithCount(input.count())).collect(Collectors.toList()));
        }
        iRecipeLayoutBuilder.addSlot(RecipeIngredientRole.OUTPUT, 91, 19).addItemStack(((AssemblingMachineRecipe)recipe.value()).getOutput());
    }
}

