/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import me.jddev0.ep.api.EPAPI;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class DispenserEMIRecipe
implements EmiRecipe {
    public static final ResourceLocation SIMPLIFIED_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/block/dispenser_front.png");
    public static final EmiStack ITEM = EmiStack.of((ItemLike)Items.DISPENSER);
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(EPAPI.id("dispenser"), (EmiRenderable)ITEM, (EmiRenderable)new EmiTexture(SIMPLIFIED_TEXTURE, 0, 0, 16, 16, 16, 16, 16, 16));
    private final ResourceLocation id;
    private final List<EmiIngredient> catalysts;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;

    public DispenserEMIRecipe(DispenserRecipe recipe) {
        this.id = recipe.id();
        this.catalysts = List.of(EmiIngredient.of((Ingredient)recipe.tool()));
        this.input = List.of(EmiIngredient.of((Ingredient)recipe.block()));
        this.output = List.of(EmiStack.of((ItemStack)recipe.output()));
    }

    public EmiRecipeCategory getCategory() {
        return CATEGORY;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getCatalysts() {
        return this.catalysts;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 100;
    }

    public int getDisplayHeight() {
        return 25;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 41, 4);
        widgets.addSlot(this.catalysts.get(0), 0, 4);
        widgets.addSlot(this.input.get(0), 18, 4);
        widgets.addSlot((EmiIngredient)this.output.get(0), 79, 4).recipeContext((EmiRecipe)this);
    }

    record DispenserRecipe(ResourceLocation id, Ingredient tool, Ingredient block, ItemStack output) {
    }
}

