/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.cctweaked;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.GenericPeripheral;
import me.jddev0.ep.block.entity.WeatherControllerBlockEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class WeatherControllerGenericPeripheral
implements GenericPeripheral {
    public String id() {
        return "energizedpower:weather_controller_peripheral";
    }

    @LuaFunction(mainThread=true)
    public final int getSelectedWeatherType(WeatherControllerBlockEntity weatherController) {
        return weatherController.getSelectedWeatherType();
    }

    @LuaFunction(mainThread=true)
    public final boolean setWeather(WeatherControllerBlockEntity weatherController, int weatherType) throws LuaException {
        ServerLevel level;
        block15: {
            block14: {
                if (weatherType != -1 && weatherType != 0 && weatherType != 1 && weatherType != 2) {
                    throw new LuaException("Weather type must be one of (-1 for reset, 0 for clear, 1 for rain, or 2 for thunder)");
                }
                if (weatherType == -1 && !weatherController.hasInfiniteWeatherChangedDuration()) {
                    throw new LuaException("Weather type -1 (reset) can only be used if an infinite duration upgrade module is installed");
                }
                Level level2 = weatherController.getLevel();
                if (!(level2 instanceof ServerLevel)) break block14;
                level = (ServerLevel)level2;
                if (weatherController.hasEnoughEnergy() && weatherController.getSelectedWeatherType() != weatherType) break block15;
            }
            return false;
        }
        if (weatherController.hasInfiniteWeatherChangedDuration()) {
            weatherController.setSelectedWeatherType(weatherType);
            if (weatherType == -1) {
                return true;
            }
        } else {
            weatherController.clearEnergy();
        }
        int duration = weatherController.getWeatherChangedDuration();
        switch (weatherType) {
            case 0: {
                level.setWeatherParameters(duration, 0, false, false);
                break;
            }
            case 1: {
                level.setWeatherParameters(0, duration, true, false);
                break;
            }
            case 2: {
                level.setWeatherParameters(0, duration, true, true);
            }
        }
        return true;
    }
}

