/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.datagen;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.datagen.generators.PageContent;
import me.jddev0.ep.datagen.generators.PageContentProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModBookPageContentProvider
extends PageContentProvider {
    private static final Style UNIFORM = Style.EMPTY.withFont(ResourceLocation.withDefaultNamespace((String)"uniform"));
    private static final Style DEFAULT_FONT = Style.EMPTY.withFont(Style.DEFAULT_FONT);
    private int chapterSortingNumber = 0;
    private int subChapterSortingNumber = 0;
    private int pageSortingNumber = 0;
    private String currentChapterIdPrefix = "";
    private String currentSubChapterIdPrefix = "";
    private String mainTableOfContentPageId;
    private String energyBlocksTableOfContentPageId;
    private final Map<String, String> tableOfContentPageTitles = new HashMap<String, String>();
    private final Map<String, List<Pair<String, PageContent>>> tableOfContentsEntries = new HashMap<String, List<Pair<String, PageContent>>>();

    public ModBookPageContentProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, "energizedpower", existingFileHelper);
    }

    @Override
    protected void registerPageContent() {
        this.registerWelcomeChapter();
        this.registerResourcesChapter();
        this.registerUpgradesChapter();
        this.registerToolsChapter();
        this.registerWorkbenchesChapter();
        this.registerEnergyItemsChapter();
        this.registerEnergyBlocksChapter();
        this.registerFluidBlocksChapter();
        this.registerItemTransportationChapter();
        this.registerFluidsChapter();
        this.registerMachineConfigurationChapter();
        this.registerEntitiesChapter();
        this.registerStructuresChapter();
        this.registerTableOfContentsPages();
    }

    private void registerWelcomeChapter() {
        this.chapterId("welcome");
        this.addSimplePage(this.pageId("welcome"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.welcome.title").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).append("\n\n")).append((Component)Component.translatable((String)"book.energizedpower.page.welcome.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)).append((Component)Component.literal((String)"\n").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)this.addLinkToComponent(Component.translatable((String)"book.energizedpower.page.welcome.2"), "https://wiki.jddev0.com/books/energized-power/page/home"))).append((Component)Component.literal((String)"\n").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)Component.translatable((String)"book.energizedpower.page.welcome.3")).append(": ").append((Component)this.addLinkToComponent(Component.translatable((String)"book.energizedpower.page.welcome.3.link"), "https://github.com/JDDev0/EnergizedPower/issues"))).append((Component)Component.literal((String)"\n").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)Component.translatable((String)"book.energizedpower.page.welcome.4")).append(": ").append((Component)this.addLinkToComponent(Component.translatable((String)"book.energizedpower.page.welcome.4.link"), "https://discord.gg/sAKDNAU7yH"))).append((Component)Component.literal((String)"\n").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)Component.translatable((String)"book.energizedpower.page.welcome.5")).append(": ").append((Component)this.addLinkToComponent(Component.translatable((String)"book.energizedpower.page.welcome.5.link"), "https://www.reddit.com/r/EnergizedPower/"))));
        this.addSimplePage(this.pageId("credits"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.credits.title").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.credits.subtitle").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GREEN, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.literal((String)"\n\u2022 ").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)Component.translatable((String)"book.energizedpower.page.credits.1")).append(": ").append((Component)this.addLinkToComponent(Component.literal((String)"flashbulbs"), "https://github.com/flashbulbs"))).append((Component)Component.literal((String)"\n\u2022 ").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)Component.translatable((String)"book.energizedpower.page.credits.2")).append(": ").append((Component)this.addLinkToComponent(Component.literal((String)"flashbulbs"), "https://github.com/flashbulbs"))).append((Component)Component.literal((String)"\n\u2022 ").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)Component.translatable((String)"book.energizedpower.page.credits.3")).append(": ").append((Component)this.addLinkToComponent(Component.literal((String)"flashbulbs"), "https://github.com/flashbulbs"))).append((Component)Component.literal((String)"\n\u2022 ").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)Component.translatable((String)"book.energizedpower.page.credits.4")).append(": ").append((Component)this.addLinkToComponent(Component.literal((String)"flashbulbs"), "https://github.com/flashbulbs"))).append((Component)Component.literal((String)"\n\u2022 ").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)Component.translatable((String)"book.energizedpower.page.credits.5")).append(": ").append((Component)this.addLinkToComponent(Component.literal((String)"HanJiang-cn"), "https://github.com/HanJiang-cn"))).append((Component)Component.literal((String)"\n\u2022 ").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)Component.translatable((String)"book.energizedpower.page.credits.6")).append(": ").append((Component)this.addLinkToComponent(Component.literal((String)"Roby1164"), "https://github.com/Roby1164"))).append((Component)Component.literal((String)"\n\u2022 ").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)Component.translatable((String)"book.energizedpower.page.credits.7")).append(": ").append((Component)this.addLinkToComponent(Component.literal((String)"Eyyup"), "https://github.com/msb-eyyup"))).append((Component)Component.literal((String)"\n\u2022 ").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)Component.translatable((String)"book.energizedpower.page.credits.8")).append(": ").append((Component)Component.literal((String)"Imperial Officer")).append(", ").append((Component)this.addLinkToComponent(Component.literal((String)"PlayboyX312"), "https://github.com/PlayboyX312"))).append((Component)Component.literal((String)"\n\u2022 ").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)Component.translatable((String)"book.energizedpower.page.credits.9")).append(": ").append((Component)this.addLinkToComponent(Component.literal((String)"Lucanoria"), "https://github.com/Lucanoria"))).append((Component)Component.literal((String)"\n\u2022 ").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)Component.translatable((String)"book.energizedpower.page.credits.10")).append(": ").append((Component)Component.literal((String)"sebbyrenewed [Discord]"))));
        this.mainTableOfContentPageId = this.pageId("table_of_contents");
        this.tableOfContentPageTitles.put(this.mainTableOfContentPageId, "book.energizedpower.page.table_of_contents.title");
        this.tableOfContentsEntries.put(this.mainTableOfContentPageId, new ArrayList());
    }

    private void registerResourcesChapter() {
        this.chapterId("resources");
        String resourcesChapterTitle = "book.energizedpower.page.chapter.resources.title";
        PageContent resourcesChapterPage = this.addChapterPage(this.pageId("resources_chapter"), (Component)Component.translatable((String)resourcesChapterTitle).withStyle(ChatFormatting.GOLD), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.chapter.resources.1")).append((Component)Component.literal((String)"\n\n").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)this.backToTableOfContentComponent(this.mainTableOfContentPageId))), EPAPI.id("textures/item/energized_copper_ingot.png"));
        this.tableOfContentsEntries.get(this.mainTableOfContentPageId).add((Pair<String, PageContent>)Pair.of((Object)resourcesChapterTitle, (Object)resourcesChapterPage));
        this.addSimplePage(this.pageId("cable_insulator"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.cable_insulator.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n\n")).append((Component)Component.translatable((String)"book.energizedpower.page.cable_insulator.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.cable_insulator.3").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), EPAPI.id("textures/item/cable_insulator.png"));
        this.addSimplePage(this.pageId("saw_blade"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.saw_blade").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), EPAPI.id("textures/item/saw_blade.png"));
        this.addSimplePage(this.pageId("silicon"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.silicon.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n\n")).append((Component)Component.translatable((String)"book.energizedpower.page.silicon.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), EPAPI.id("textures/item/silicon.png"));
        this.addSimplePage(this.pageId("sawdust"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.sawdust.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n\n")).append((Component)Component.translatable((String)"book.energizedpower.page.sawdust.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), EPAPI.id("textures/item/sawdust.png"));
        this.addSimplePage(this.pageId("fertilizers"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.fertilizers").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new ResourceLocation[]{EPAPI.id("textures/item/basic_fertilizer.png"), EPAPI.id("textures/item/good_fertilizer.png"), EPAPI.id("textures/item/advanced_fertilizer.png")});
        this.addSimplePage(this.pageId("ore_dusts"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.ore_dusts").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new ResourceLocation[]{EPAPI.id("textures/item/tin_dust.png"), EPAPI.id("textures/item/copper_dust.png"), EPAPI.id("textures/item/iron_dust.png"), EPAPI.id("textures/item/gold_dust.png")});
        this.addSimplePage(this.pageId("charcoal_dust"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.charcoal_dust").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), EPAPI.id("textures/item/charcoal_dust.png"));
        this.addSimplePage(this.pageId("charcoal_filter"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.charcoal_filter").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), EPAPI.id("textures/item/charcoal_filter.png"));
        this.addSimplePage(this.pageId("plates"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.plates.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.plates.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM)), new ResourceLocation[]{EPAPI.id("textures/item/tin_plate.png"), EPAPI.id("textures/item/copper_plate.png"), EPAPI.id("textures/item/iron_plate.png"), EPAPI.id("textures/item/gold_plate.png"), EPAPI.id("textures/item/advanced_alloy_plate.png"), EPAPI.id("textures/item/energized_copper_plate.png"), EPAPI.id("textures/item/energized_gold_plate.png")});
        this.addSimplePage(this.pageId("alloys"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.alloys").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new ResourceLocation[]{EPAPI.id("textures/item/steel_ingot.png"), EPAPI.id("textures/item/redstone_alloy_ingot.png"), EPAPI.id("textures/item/advanced_alloy_ingot.png")});
        this.addSimplePage(this.pageId("metal_products"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.metal_products.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.metal_products.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM)), new ResourceLocation[]{EPAPI.id("textures/item/iron_gear.png"), EPAPI.id("textures/item/iron_rod.png"), EPAPI.id("textures/item/tin_wire.png"), EPAPI.id("textures/item/copper_wire.png"), EPAPI.id("textures/item/gold_wire.png"), EPAPI.id("textures/item/energized_copper_wire.png"), EPAPI.id("textures/item/energized_gold_wire.png")});
        this.addSimplePage(this.pageId("circuits"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.circuits").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new ResourceLocation[]{EPAPI.id("textures/item/basic_circuit.png"), EPAPI.id("textures/item/advanced_circuit.png"), EPAPI.id("textures/item/processing_unit.png"), EPAPI.id("textures/item/teleporter_processing_unit.png")});
        this.addSimplePage(this.pageId("energized_copper_ingot"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.energized_copper_ingot.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.energized_copper_ingot.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.energized_copper_ingot.3").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)).append((Component)Component.translatable((String)"book.energizedpower.page.energized_copper_ingot.4").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM)), EPAPI.id("textures/item/energized_copper_ingot.png"));
        this.addSimplePage(this.pageId("energized_gold_ingot"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.energized_gold_ingot").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), EPAPI.id("textures/item/energized_gold_ingot.png"));
        this.addSimplePage(this.pageId("energized_crystal_matrix"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.energized_crystal_matrix").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), EPAPI.id("textures/item/energized_crystal_matrix.png"));
    }

    private void registerUpgradesChapter() {
        this.chapterId("upgrades");
        String upgradesChapterTitle = "book.energizedpower.page.chapter.upgrades.title";
        PageContent upgradesChapterPage = this.addChapterPage(this.pageId("upgrades_chapter"), (Component)Component.translatable((String)upgradesChapterTitle).withStyle(ChatFormatting.GOLD), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.chapter.upgrades")).append((Component)Component.literal((String)"\n\n").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)this.backToTableOfContentComponent(this.mainTableOfContentPageId))), EPAPI.id("textures/item/speed_upgrade_module_1.png"));
        this.tableOfContentsEntries.get(this.mainTableOfContentPageId).add((Pair<String, PageContent>)Pair.of((Object)upgradesChapterTitle, (Object)upgradesChapterPage));
        this.addSimplePage(this.pageId("speed_upgrades"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.speed_upgrades").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new ResourceLocation[]{EPAPI.id("textures/item/speed_upgrade_module_1.png"), EPAPI.id("textures/item/speed_upgrade_module_2.png"), EPAPI.id("textures/item/speed_upgrade_module_3.png"), EPAPI.id("textures/item/speed_upgrade_module_4.png"), EPAPI.id("textures/item/speed_upgrade_module_5.png")});
        this.addSimplePage(this.pageId("energy_efficiency_upgrades"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.energy_efficiency_upgrades").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new ResourceLocation[]{EPAPI.id("textures/item/energy_efficiency_upgrade_module_1.png"), EPAPI.id("textures/item/energy_efficiency_upgrade_module_2.png"), EPAPI.id("textures/item/energy_efficiency_upgrade_module_3.png"), EPAPI.id("textures/item/energy_efficiency_upgrade_module_4.png"), EPAPI.id("textures/item/energy_efficiency_upgrade_module_5.png")});
        this.addSimplePage(this.pageId("energy_capacity_upgrades"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.energy_capacity_upgrades").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new ResourceLocation[]{EPAPI.id("textures/item/energy_capacity_upgrade_module_1.png"), EPAPI.id("textures/item/energy_capacity_upgrade_module_2.png"), EPAPI.id("textures/item/energy_capacity_upgrade_module_3.png"), EPAPI.id("textures/item/energy_capacity_upgrade_module_4.png"), EPAPI.id("textures/item/energy_capacity_upgrade_module_5.png")});
        this.addSimplePage(this.pageId("duration_upgrades"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.duration_upgrades.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.duration_upgrades.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM)), new ResourceLocation[]{EPAPI.id("textures/item/duration_upgrade_module_1.png"), EPAPI.id("textures/item/duration_upgrade_module_2.png"), EPAPI.id("textures/item/duration_upgrade_module_3.png"), EPAPI.id("textures/item/duration_upgrade_module_4.png"), EPAPI.id("textures/item/duration_upgrade_module_5.png"), EPAPI.id("textures/item/duration_upgrade_module_6.png")});
        this.addSimplePage(this.pageId("range_upgrades"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.range_upgrades").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new ResourceLocation[]{EPAPI.id("textures/item/range_upgrade_module_1.png"), EPAPI.id("textures/item/range_upgrade_module_2.png"), EPAPI.id("textures/item/range_upgrade_module_3.png")});
        this.addSimplePage(this.pageId("extraction_depth_upgrades"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.extraction_depth_upgrades").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new ResourceLocation[]{EPAPI.id("textures/item/extraction_depth_upgrade_module_1.png"), EPAPI.id("textures/item/extraction_depth_upgrade_module_2.png"), EPAPI.id("textures/item/extraction_depth_upgrade_module_3.png"), EPAPI.id("textures/item/extraction_depth_upgrade_module_4.png"), EPAPI.id("textures/item/extraction_depth_upgrade_module_5.png")});
        this.addSimplePage(this.pageId("extraction_range_upgrades"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.extraction_range_upgrades").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new ResourceLocation[]{EPAPI.id("textures/item/extraction_range_upgrade_module_1.png"), EPAPI.id("textures/item/extraction_range_upgrade_module_2.png"), EPAPI.id("textures/item/extraction_range_upgrade_module_3.png"), EPAPI.id("textures/item/extraction_range_upgrade_module_4.png"), EPAPI.id("textures/item/extraction_range_upgrade_module_5.png")});
        this.addSimplePage(this.pageId("furnace_mode_upgrades"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.furnace_mode_upgrades").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new ResourceLocation[]{EPAPI.id("textures/item/blast_furnace_upgrade_module.png"), EPAPI.id("textures/item/smoker_upgrade_module.png")});
        this.addSimplePage(this.pageId("moon_light_upgrades"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.moon_light_upgrades").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new ResourceLocation[]{EPAPI.id("textures/item/moon_light_upgrade_module_1.png"), EPAPI.id("textures/item/moon_light_upgrade_module_2.png"), EPAPI.id("textures/item/moon_light_upgrade_module_3.png")});
    }

    private void registerToolsChapter() {
        this.chapterId("tools");
        String toolsChapterTitle = "book.energizedpower.page.chapter.tools.title";
        PageContent toolsChapterPage = this.addChapterPage(this.pageId("tools_chapter"), (Component)Component.translatable((String)toolsChapterTitle).withStyle(ChatFormatting.GOLD), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.chapter.tools")).append((Component)Component.literal((String)"\n\n").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)this.backToTableOfContentComponent(this.mainTableOfContentPageId))), EPAPI.id("textures/item/stone_hammer.png"));
        this.tableOfContentsEntries.get(this.mainTableOfContentPageId).add((Pair<String, PageContent>)Pair.of((Object)toolsChapterTitle, (Object)toolsChapterPage));
        this.addSimplePage(this.pageId("hammers"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.hammers").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new ResourceLocation[]{EPAPI.id("textures/item/wooden_hammer.png"), EPAPI.id("textures/item/stone_hammer.png"), EPAPI.id("textures/item/iron_hammer.png"), EPAPI.id("textures/item/golden_hammer.png"), EPAPI.id("textures/item/diamond_hammer.png"), EPAPI.id("textures/item/netherite_hammer.png")});
        this.addSimplePage(this.pageId("cutters"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.cutters.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.cutters.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), EPAPI.id("textures/item/cutter.png"));
        this.addSimplePage(this.pageId("wrench"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.wrench").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), EPAPI.id("textures/item/wrench.png"));
    }

    private void registerWorkbenchesChapter() {
        this.chapterId("workbenches");
        String workbenchesChapterTitle = "book.energizedpower.page.chapter.workbenches.title";
        PageContent workbenchesChapterPage = this.addChapterPage(this.pageId("workbenches_chapter"), (Component)Component.translatable((String)workbenchesChapterTitle).withStyle(ChatFormatting.GOLD), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.chapter.workbenches")).append((Component)Component.literal((String)"\n\n").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)this.backToTableOfContentComponent(this.mainTableOfContentPageId))), Blocks.CRAFTING_TABLE);
        this.tableOfContentsEntries.get(this.mainTableOfContentPageId).add((Pair<String, PageContent>)Pair.of((Object)workbenchesChapterTitle, (Object)workbenchesChapterPage));
        this.addSimplePage(this.pageId("press_mold_maker"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.press_mold_maker").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), (Block)EPBlocks.PRESS_MOLD_MAKER.get());
        this.addSimplePage(this.pageId("alloy_furnace"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.alloy_furnace.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.alloy_furnace.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.alloy_furnace.3").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), (Block)EPBlocks.ALLOY_FURNACE.get());
    }

    private void registerEnergyItemsChapter() {
        this.chapterId("energy_items");
        String energyItemsChapterTitle = "book.energizedpower.page.chapter.energy_items.title";
        PageContent energyItemsChapterPage = this.addChapterPage(this.pageId("energy_items_chapter"), (Component)Component.translatable((String)energyItemsChapterTitle).withStyle(ChatFormatting.GOLD), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.chapter.energy_items")).append((Component)Component.literal((String)"\n\n").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)this.backToTableOfContentComponent(this.mainTableOfContentPageId))));
        this.tableOfContentsEntries.get(this.mainTableOfContentPageId).add((Pair<String, PageContent>)Pair.of((Object)energyItemsChapterTitle, (Object)energyItemsChapterPage));
        this.addSimplePage(this.pageId("inventory_coal_engine"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.inventory_coal_engine.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append(" ")).append((Component)Component.translatable((String)"book.energizedpower.page.inventory_coal_engine.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append(" ")).append((Component)Component.translatable((String)"book.energizedpower.page.inventory_coal_engine.3").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)).append((Component)Component.translatable((String)"book.energizedpower.page.inventory_coal_engine.4").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM)), EPAPI.id("textures/item/inventory_coal_engine_on.png"));
        this.addSimplePage(this.pageId("inventory_charger"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.inventory_charger.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.inventory_charger.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM)), EPAPI.id("textures/item/inventory_charger.png"));
        this.addSimplePage(this.pageId("inventory_teleporter"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.inventory_teleporter").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), EPAPI.id("textures/item/inventory_teleporter.png"));
        this.addSimplePage(this.pageId("energy_analyzer"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.energy_analyzer.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n\n")).append((Component)Component.translatable((String)"book.energizedpower.page.energy_analyzer.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), EPAPI.id("textures/item/energy_analyzer.png"));
        this.addSimplePage(this.pageId("fluid_analyzer"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.fluid_analyzer.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n\n")).append((Component)Component.translatable((String)"book.energizedpower.page.fluid_analyzer.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), EPAPI.id("textures/item/fluid_analyzer.png"));
        this.addSimplePage(this.pageId("batteries"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.batteries.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n\n")).append((Component)Component.translatable((String)"book.energizedpower.page.batteries.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new ResourceLocation[]{EPAPI.id("textures/item/battery_1.png"), EPAPI.id("textures/item/battery_2.png"), EPAPI.id("textures/item/battery_3.png"), EPAPI.id("textures/item/battery_4.png"), EPAPI.id("textures/item/battery_5.png"), EPAPI.id("textures/item/battery_6.png"), EPAPI.id("textures/item/battery_7.png"), EPAPI.id("textures/item/battery_8.png")});
    }

    private void registerEnergyBlocksChapter() {
        this.chapterId("energy_blocks");
        this.registerEnergyBlocksChapterMainSubChapter();
        this.registerEnergyBlocksChapterGeneralSubChapter();
        this.registerEnergyBlocksChapterEnergyTransportationSubChapter();
        this.registerEnergyBlocksChapterEnergyStorageSubChapter();
        this.registerEnergyBlocksChapterEnergyProductionSubChapter();
        this.registerEnergyBlocksChapterEnergyConsumptionSubChapter();
    }

    private void registerEnergyBlocksChapterMainSubChapter() {
        this.subChapterId("main");
        String energyBlocksMainChapterTitle = "book.energizedpower.page.chapter.energy_blocks.title";
        PageContent energyBlocksMainChapterPage = this.addChapterPage(this.pageId("energy_blocks_chapter"), (Component)Component.translatable((String)energyBlocksMainChapterTitle).withStyle(ChatFormatting.GOLD), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.chapter.energy_blocks")).append((Component)Component.literal((String)"\n\n").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)this.backToTableOfContentComponent(this.mainTableOfContentPageId))));
        this.tableOfContentsEntries.get(this.mainTableOfContentPageId).add((Pair<String, PageContent>)Pair.of((Object)energyBlocksMainChapterTitle, (Object)energyBlocksMainChapterPage));
        this.energyBlocksTableOfContentPageId = this.pageId("table_of_contents");
        this.tableOfContentPageTitles.put(this.energyBlocksTableOfContentPageId, "book.energizedpower.page.energy_blocks.table_of_contents.title");
        this.tableOfContentsEntries.put(this.energyBlocksTableOfContentPageId, new ArrayList());
    }

    private void registerEnergyBlocksChapterGeneralSubChapter() {
        this.subChapterId("general");
        String energyBlocksGeneralChapterTitle = "book.energizedpower.page.chapter.energy_blocks.general.title";
        PageContent energyBlocksGeneralChapterPage = this.addChapterPage(this.pageId("general_chapter"), (Component)Component.translatable((String)energyBlocksGeneralChapterTitle).withStyle(ChatFormatting.GOLD), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.chapter.energy_blocks.general")).append((Component)Component.literal((String)"\n\n").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)this.backToTableOfContentComponent(this.energyBlocksTableOfContentPageId))));
        this.tableOfContentsEntries.get(this.energyBlocksTableOfContentPageId).add((Pair<String, PageContent>)Pair.of((Object)energyBlocksGeneralChapterTitle, (Object)energyBlocksGeneralChapterPage));
        this.addSimplePage(this.pageId("machine_frames"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.machine_frames.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.machine_frames.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new Block[]{(Block)EPBlocks.BASIC_MACHINE_FRAME.get(), (Block)EPBlocks.HARDENED_MACHINE_FRAME.get(), (Block)EPBlocks.ADVANCED_MACHINE_FRAME.get(), (Block)EPBlocks.REINFORCED_ADVANCED_MACHINE_FRAME.get()});
    }

    private void registerEnergyBlocksChapterEnergyTransportationSubChapter() {
        this.subChapterId("energy_transportation");
        String energyBlocksEnergyTransportationChapterTitle = "book.energizedpower.page.chapter.energy_blocks.energy_transportation.title";
        PageContent energyBlocksEnergyTransportationChapterPage = this.addChapterPage(this.pageId("energy_transportation_chapter"), (Component)Component.translatable((String)energyBlocksEnergyTransportationChapterTitle).withStyle(ChatFormatting.GOLD), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.chapter.energy_blocks.energy_transportation")).append((Component)Component.literal((String)"\n\n").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)this.backToTableOfContentComponent(this.energyBlocksTableOfContentPageId))));
        this.tableOfContentsEntries.get(this.energyBlocksTableOfContentPageId).add((Pair<String, PageContent>)Pair.of((Object)energyBlocksEnergyTransportationChapterTitle, (Object)energyBlocksEnergyTransportationChapterPage));
        this.addSimplePage(this.pageId("cables"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.cables.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append(" ")).append((Component)Component.translatable((String)"book.energizedpower.page.cables.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append(" ")).append((Component)Component.translatable((String)"book.energizedpower.page.cables.3").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM)), new Block[]{(Block)EPBlocks.TIN_CABLE.get(), (Block)EPBlocks.COPPER_CABLE.get(), (Block)EPBlocks.GOLD_CABLE.get(), (Block)EPBlocks.ENERGIZED_COPPER_CABLE.get(), (Block)EPBlocks.ENERGIZED_GOLD_CABLE.get(), (Block)EPBlocks.ENERGIZED_CRYSTAL_MATRIX_CABLE.get()});
        this.addSimplePage(this.pageId("transformers"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.transformers.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.transformers.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.transformers.3").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.transformers.4").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.transformers.5").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.transformers.6").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.transformers.7").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.transformers.8").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.transformers.9").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM)), new Block[]{(Block)EPBlocks.LV_TRANSFORMER_1_TO_N.get(), (Block)EPBlocks.LV_TRANSFORMER_3_TO_3.get(), (Block)EPBlocks.LV_TRANSFORMER_N_TO_1.get(), (Block)EPBlocks.CONFIGURABLE_LV_TRANSFORMER.get(), (Block)EPBlocks.MV_TRANSFORMER_1_TO_N.get(), (Block)EPBlocks.MV_TRANSFORMER_3_TO_3.get(), (Block)EPBlocks.MV_TRANSFORMER_N_TO_1.get(), (Block)EPBlocks.CONFIGURABLE_MV_TRANSFORMER.get(), (Block)EPBlocks.HV_TRANSFORMER_1_TO_N.get(), (Block)EPBlocks.HV_TRANSFORMER_3_TO_3.get(), (Block)EPBlocks.HV_TRANSFORMER_N_TO_1.get(), (Block)EPBlocks.CONFIGURABLE_HV_TRANSFORMER.get(), (Block)EPBlocks.EHV_TRANSFORMER_1_TO_N.get(), (Block)EPBlocks.EHV_TRANSFORMER_3_TO_3.get(), (Block)EPBlocks.EHV_TRANSFORMER_N_TO_1.get(), (Block)EPBlocks.CONFIGURABLE_EHV_TRANSFORMER.get()});
        this.addSimplePage(this.pageId("minecart_charger_uncharger"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.minecart_charger_uncharger.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append(" ")).append((Component)Component.translatable((String)"book.energizedpower.page.minecart_charger_uncharger.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.minecart_charger_uncharger.3").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new Block[]{(Block)EPBlocks.MINECART_CHARGER.get(), (Block)EPBlocks.MINECART_UNCHARGER.get(), (Block)EPBlocks.ADVANCED_MINECART_CHARGER.get(), (Block)EPBlocks.ADVANCED_MINECART_UNCHARGER.get()});
    }

    private void registerEnergyBlocksChapterEnergyStorageSubChapter() {
        this.subChapterId("energy_storage");
        String energyBlocksEnergyStorageChapterTitle = "book.energizedpower.page.chapter.energy_blocks.energy_storage.title";
        PageContent energyBlocksEnergyStorageChapterPage = this.addChapterPage(this.pageId("energy_storage_chapter"), (Component)Component.translatable((String)energyBlocksEnergyStorageChapterTitle).withStyle(ChatFormatting.GOLD), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.chapter.energy_blocks.energy_storage")).append((Component)Component.literal((String)"\n\n").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)this.backToTableOfContentComponent(this.energyBlocksTableOfContentPageId))));
        this.tableOfContentsEntries.get(this.energyBlocksTableOfContentPageId).add((Pair<String, PageContent>)Pair.of((Object)energyBlocksEnergyStorageChapterTitle, (Object)energyBlocksEnergyStorageChapterPage));
        this.addSimplePage(this.pageId("battery_box"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.battery_box").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new Block[]{(Block)EPBlocks.BATTERY_BOX.get(), (Block)EPBlocks.ADVANCED_BATTERY_BOX.get()});
    }

    private void registerEnergyBlocksChapterEnergyProductionSubChapter() {
        this.subChapterId("energy_production");
        String energyBlocksEnergyProductionChapterTitle = "book.energizedpower.page.chapter.energy_blocks.energy_production.title";
        PageContent energyBlocksEnergyProductionChapterPage = this.addChapterPage(this.pageId("energy_production_chapter"), (Component)Component.translatable((String)energyBlocksEnergyProductionChapterTitle).withStyle(ChatFormatting.GOLD), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.chapter.energy_blocks.energy_production")).append((Component)Component.literal((String)"\n\n").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)this.backToTableOfContentComponent(this.energyBlocksTableOfContentPageId))));
        this.tableOfContentsEntries.get(this.energyBlocksTableOfContentPageId).add((Pair<String, PageContent>)Pair.of((Object)energyBlocksEnergyProductionChapterTitle, (Object)energyBlocksEnergyProductionChapterPage));
        this.addSimplePage(this.pageId("solar_cells"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.solar_cells.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.solar_cells.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new ResourceLocation[]{EPAPI.id("textures/item/basic_solar_cell.png"), EPAPI.id("textures/item/advanced_solar_cell.png"), EPAPI.id("textures/item/reinforced_advanced_solar_cell.png")});
        this.addSimplePage(this.pageId("solar_panels"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.solar_panels.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.solar_panels.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new Block[]{(Block)EPBlocks.SOLAR_PANEL_1.get(), (Block)EPBlocks.SOLAR_PANEL_2.get(), (Block)EPBlocks.SOLAR_PANEL_3.get(), (Block)EPBlocks.SOLAR_PANEL_4.get(), (Block)EPBlocks.SOLAR_PANEL_5.get(), (Block)EPBlocks.SOLAR_PANEL_6.get()});
        this.addSimplePage(this.pageId("coal_engine"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.coal_engine.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n\n")).append((Component)Component.translatable((String)"book.energizedpower.page.coal_engine.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM)), (Block)EPBlocks.COAL_ENGINE.get());
        this.addSimplePage(this.pageId("heat_generator"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.heat_generator.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append(" ")).append((Component)Component.translatable((String)"book.energizedpower.page.heat_generator.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.heat_generator.3").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM).append(" ")).append((Component)Component.translatable((String)"book.energizedpower.page.heat_generator.4").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM)), (Block)EPBlocks.HEAT_GENERATOR.get());
        this.addSimplePage(this.pageId("thermal_generator"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.thermal_generator.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.thermal_generator.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM)), (Block)EPBlocks.THERMAL_GENERATOR.get());
        this.addSimplePage(this.pageId("lightning_generator"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.lightning_generator.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n\n")).append((Component)Component.translatable((String)"book.energizedpower.page.lightning_generator.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM)), (Block)EPBlocks.LIGHTNING_GENERATOR.get());
    }

    private void registerEnergyBlocksChapterEnergyConsumptionSubChapter() {
        this.subChapterId("energy_consumption");
        String energyBlocksEnergyConsumptionChapterTitle = "book.energizedpower.page.chapter.energy_blocks.energy_consumption.title";
        PageContent energyBlocksEnergyConsumptionChapterPage = this.addChapterPage(this.pageId("energy_consumption_chapter"), (Component)Component.translatable((String)energyBlocksEnergyConsumptionChapterTitle).withStyle(ChatFormatting.GOLD), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.chapter.energy_blocks.energy_consumption")).append((Component)Component.literal((String)"\n\n").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)this.backToTableOfContentComponent(this.energyBlocksTableOfContentPageId))));
        this.tableOfContentsEntries.get(this.energyBlocksTableOfContentPageId).add((Pair<String, PageContent>)Pair.of((Object)energyBlocksEnergyConsumptionChapterTitle, (Object)energyBlocksEnergyConsumptionChapterPage));
        this.addSimplePage(this.pageId("powered_lamp"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.powered_lamp").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), (Block)EPBlocks.POWERED_LAMP.get());
        this.addSimplePage(this.pageId("powered_furnaces"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.powered_furnaces.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.powered_furnaces.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new Block[]{(Block)EPBlocks.POWERED_FURNACE.get(), (Block)EPBlocks.ADVANCED_POWERED_FURNACE.get()});
        this.addSimplePage(this.pageId("auto_crafters"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.auto_crafters.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.auto_crafters.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.auto_crafters.3").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.auto_crafters.4").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM)), new Block[]{(Block)EPBlocks.AUTO_CRAFTER.get(), (Block)EPBlocks.ADVANCED_AUTO_CRAFTER.get()});
        this.addSimplePage(this.pageId("crushers"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.crushers.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.crushers.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new Block[]{(Block)EPBlocks.CRUSHER.get(), (Block)EPBlocks.ADVANCED_CRUSHER.get()});
        this.addSimplePage(this.pageId("pulverizers"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.pulverizers.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.pulverizers.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new Block[]{(Block)EPBlocks.PULVERIZER.get(), (Block)EPBlocks.ADVANCED_PULVERIZER.get()});
        this.addSimplePage(this.pageId("sawmill"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.sawmill.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n\n")).append((Component)Component.translatable((String)"book.energizedpower.page.sawmill.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM)), (Block)EPBlocks.SAWMILL.get());
        this.addSimplePage(this.pageId("compressor"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.compressor").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), (Block)EPBlocks.COMPRESSOR.get());
        this.addSimplePage(this.pageId("metal_press"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.metal_press.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.metal_press.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.metal_press.3").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM).append(" ")).append((Component)Component.translatable((String)"book.energizedpower.page.metal_press.4").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM)), (Block)EPBlocks.METAL_PRESS.get());
        this.addSimplePage(this.pageId("auto_press_mold_maker"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.auto_press_mold_maker").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), (Block)EPBlocks.AUTO_PRESS_MOLD_MAKER.get());
        this.addSimplePage(this.pageId("auto_stonecutter"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.auto_stonecutter").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), (Block)EPBlocks.AUTO_STONECUTTER.get());
        this.addSimplePage(this.pageId("assembling_machine"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.assembling_machine.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.assembling_machine.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.assembling_machine.3").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM)), (Block)EPBlocks.ASSEMBLING_MACHINE.get());
        this.addSimplePage(this.pageId("plant_growth_chamber"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.plant_growth_chamber.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.plant_growth_chamber.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.plant_growth_chamber.3").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.plant_growth_chamber.4").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.plant_growth_chamber.5").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.plant_growth_chamber.6").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.plant_growth_chamber.7").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), (Block)EPBlocks.PLANT_GROWTH_CHAMBER.get());
        this.addSimplePage(this.pageId("stone_liquefier"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.stone_liquefier.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append(" ")).append((Component)Component.translatable((String)"book.energizedpower.page.stone_liquefier.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM)), (Block)EPBlocks.STONE_LIQUEFIER.get());
        this.addSimplePage(this.pageId("stone_solidifier"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.stone_solidifier.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append(" ")).append((Component)Component.translatable((String)"book.energizedpower.page.stone_solidifier.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM)), (Block)EPBlocks.STONE_SOLIDIFIER.get());
        this.addSimplePage(this.pageId("filtration_plant"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.filtration_plant.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.filtration_plant.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), (Block)EPBlocks.FILTRATION_PLANT.get());
        this.addSimplePage(this.pageId("fluid_transposer"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.fluid_transposer").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), (Block)EPBlocks.FLUID_TRANSPOSER.get());
        this.addSimplePage(this.pageId("induction_smelter"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.induction_smelter.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.induction_smelter.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.induction_smelter.3").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), (Block)EPBlocks.INDUCTION_SMELTER.get());
        this.addSimplePage(this.pageId("block_placer"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.block_placer.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n\n")).append((Component)Component.translatable((String)"book.energizedpower.page.block_placer.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM)), (Block)EPBlocks.BLOCK_PLACER.get());
        this.addSimplePage(this.pageId("fluid_filler_fluid_drainer"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.fluid_filler_fluid_drainer").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new Block[]{(Block)EPBlocks.FLUID_FILLER.get(), (Block)EPBlocks.FLUID_DRAINER.get()});
        this.addSimplePage(this.pageId("fluid_pumps"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.fluid_pumps").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new Block[]{(Block)EPBlocks.FLUID_PUMP.get(), (Block)EPBlocks.ADVANCED_FLUID_PUMP.get()});
        this.addSimplePage(this.pageId("charger_uncharger"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.charger_uncharger.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.charger_uncharger.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new Block[]{(Block)EPBlocks.CHARGER.get(), (Block)EPBlocks.UNCHARGER.get(), (Block)EPBlocks.ADVANCED_CHARGER.get(), (Block)EPBlocks.ADVANCED_UNCHARGER.get()});
        this.addSimplePage(this.pageId("charging_station"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.charging_station").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), (Block)EPBlocks.CHARGING_STATION.get());
        this.addSimplePage(this.pageId("crystal_growth_chamber"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.crystal_growth_chamber").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), (Block)EPBlocks.CRYSTAL_GROWTH_CHAMBER.get());
        this.addSimplePage(this.pageId("energizer"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.energizer").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), (Block)EPBlocks.ENERGIZER.get());
        this.addSimplePage(this.pageId("weather_controller"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.weather_controller").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), (Block)EPBlocks.WEATHER_CONTROLLER.get());
        this.addSimplePage(this.pageId("time_controller"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.time_controller.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n\n")).append((Component)Component.translatable((String)"book.energizedpower.page.time_controller.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM)), (Block)EPBlocks.TIME_CONTROLLER.get());
        this.addSimplePage(this.pageId("teleporter_matrix"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.teleporter_matrix.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n\n")).append((Component)Component.translatable((String)"book.energizedpower.page.teleporter_matrix.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM)), EPAPI.id("textures/item/teleporter_matrix.png"));
        this.addSimplePage(this.pageId("teleporter"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.teleporter.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n\n")).append((Component)Component.translatable((String)"book.energizedpower.page.teleporter.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM).append("\n\n")).append((Component)Component.translatable((String)"book.energizedpower.page.teleporter.3.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM).append((Component)Component.literal((String)" [").withStyle(ChatFormatting.BLACK).withStyle(DEFAULT_FONT)).append((Component)Component.keybind((String)"key.energizedpower.teleporter.use").withStyle(ChatFormatting.DARK_GRAY).withStyle(DEFAULT_FONT)).append((Component)Component.literal((String)"] ").withStyle(ChatFormatting.BLACK).withStyle(DEFAULT_FONT)).append((Component)Component.translatable((String)"book.energizedpower.page.teleporter.3.2"))), (Block)EPBlocks.TELEPORTER.get());
    }

    private void registerFluidBlocksChapter() {
        this.chapterId("fluid_blocks");
        String fluidBlocksChapterTitle = "book.energizedpower.page.chapter.fluid_blocks.title";
        PageContent fluidBlocksChapterPage = this.addChapterPage(this.pageId("fluid_blocks_chapter"), (Component)Component.translatable((String)fluidBlocksChapterTitle).withStyle(ChatFormatting.GOLD), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.chapter.fluid_blocks")).append((Component)Component.literal((String)"\n\n").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)this.backToTableOfContentComponent(this.mainTableOfContentPageId))));
        this.tableOfContentsEntries.get(this.mainTableOfContentPageId).add((Pair<String, PageContent>)Pair.of((Object)fluidBlocksChapterTitle, (Object)fluidBlocksChapterPage));
        this.addSimplePage(this.pageId("fluid_pipes"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.fluid_pipes.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.fluid_pipes.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.fluid_pipes.3").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.fluid_pipes.4").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM)), new Block[]{(Block)EPBlocks.IRON_FLUID_PIPE.get(), (Block)EPBlocks.GOLDEN_FLUID_PIPE.get()});
        this.addSimplePage(this.pageId("fluid_tanks"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.fluid_tanks.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.fluid_tanks.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM)), new Block[]{(Block)EPBlocks.FLUID_TANK_SMALL.get(), (Block)EPBlocks.FLUID_TANK_MEDIUM.get(), (Block)EPBlocks.FLUID_TANK_LARGE.get()});
        this.addSimplePage(this.pageId("drain"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.drain.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.drain.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), (Block)EPBlocks.DRAIN.get());
    }

    private void registerItemTransportationChapter() {
        this.chapterId("item_transportation");
        String itemTransportationChapterTitle = "book.energizedpower.page.chapter.item_transportation.title";
        PageContent itemTransportationChapterPage = this.addChapterPage(this.pageId("item_transportation_chapter"), (Component)Component.translatable((String)itemTransportationChapterTitle).withStyle(ChatFormatting.GOLD), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.chapter.item_transportation")).append((Component)Component.literal((String)"\n\n").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)this.backToTableOfContentComponent(this.mainTableOfContentPageId))));
        this.tableOfContentsEntries.get(this.mainTableOfContentPageId).add((Pair<String, PageContent>)Pair.of((Object)itemTransportationChapterTitle, (Object)itemTransportationChapterPage));
        this.addSimplePage(this.pageId("item_conveyor_belt"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.item_conveyor_belt.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.item_conveyor_belt.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.item_conveyor_belt.3").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.item_conveyor_belt.4").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.item_conveyor_belt.5").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.item_conveyor_belt.6").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new Block[]{(Block)EPBlocks.BASIC_ITEM_CONVEYOR_BELT.get(), (Block)EPBlocks.FAST_ITEM_CONVEYOR_BELT.get(), (Block)EPBlocks.EXPRESS_ITEM_CONVEYOR_BELT.get()});
        this.addSimplePage(this.pageId("item_conveyor_belt_loader"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.item_conveyor_belt_loader.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.item_conveyor_belt_loader.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.item_conveyor_belt_loader.3").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.item_conveyor_belt_loader.4").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.item_conveyor_belt_loader.5").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new Block[]{(Block)EPBlocks.BASIC_ITEM_CONVEYOR_BELT_LOADER.get(), (Block)EPBlocks.FAST_ITEM_CONVEYOR_BELT_LOADER.get(), (Block)EPBlocks.EXPRESS_ITEM_CONVEYOR_BELT_LOADER.get()});
        this.addSimplePage(this.pageId("item_conveyor_belt_sorter"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.item_conveyor_belt_sorter.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.item_conveyor_belt_sorter.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.item_conveyor_belt_sorter.3").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.item_conveyor_belt_sorter.4").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.item_conveyor_belt_sorter.5").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.item_conveyor_belt_sorter.6").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.item_conveyor_belt_sorter.7").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.item_conveyor_belt_sorter.8").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.item_conveyor_belt_sorter.9").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new Block[]{(Block)EPBlocks.BASIC_ITEM_CONVEYOR_BELT_SORTER.get(), (Block)EPBlocks.FAST_ITEM_CONVEYOR_BELT_SORTER.get(), (Block)EPBlocks.EXPRESS_ITEM_CONVEYOR_BELT_SORTER.get()});
        this.addSimplePage(this.pageId("item_conveyor_belt_switch"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.item_conveyor_belt_switch.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append(" ")).append((Component)Component.translatable((String)"book.energizedpower.page.item_conveyor_belt_switch.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new Block[]{(Block)EPBlocks.BASIC_ITEM_CONVEYOR_BELT_SWITCH.get(), (Block)EPBlocks.FAST_ITEM_CONVEYOR_BELT_SWITCH.get(), (Block)EPBlocks.EXPRESS_ITEM_CONVEYOR_BELT_SWITCH.get()});
        this.addSimplePage(this.pageId("item_conveyor_belt_splitter"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.item_conveyor_belt_splitter").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new Block[]{(Block)EPBlocks.BASIC_ITEM_CONVEYOR_BELT_SPLITTER.get(), (Block)EPBlocks.FAST_ITEM_CONVEYOR_BELT_SPLITTER.get(), (Block)EPBlocks.EXPRESS_ITEM_CONVEYOR_BELT_SPLITTER.get()});
        this.addSimplePage(this.pageId("item_conveyor_belt_merger"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.item_conveyor_belt_merger").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new Block[]{(Block)EPBlocks.BASIC_ITEM_CONVEYOR_BELT_MERGER.get(), (Block)EPBlocks.FAST_ITEM_CONVEYOR_BELT_MERGER.get(), (Block)EPBlocks.EXPRESS_ITEM_CONVEYOR_BELT_MERGER.get()});
        this.addSimplePage(this.pageId("item_silos"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.item_silos.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append(" ")).append((Component)Component.translatable((String)"book.energizedpower.page.item_silos.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.item_silos.3").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.ITALIC}).withStyle(UNIFORM)), new Block[]{(Block)EPBlocks.ITEM_SILO_TINY.get(), (Block)EPBlocks.ITEM_SILO_SMALL.get(), (Block)EPBlocks.ITEM_SILO_MEDIUM.get(), (Block)EPBlocks.ITEM_SILO_LARGE.get(), (Block)EPBlocks.ITEM_SILO_GIANT.get()});
    }

    private void registerFluidsChapter() {
        this.chapterId("fluids");
        String fluidsChapterTitle = "book.energizedpower.page.chapter.fluids.title";
        PageContent fluidsChapterPage = this.addChapterPage(this.pageId("fluids_chapter"), (Component)Component.translatable((String)fluidsChapterTitle).withStyle(ChatFormatting.GOLD), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.chapter.fluids")).append((Component)Component.literal((String)"\n\n").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)this.backToTableOfContentComponent(this.mainTableOfContentPageId))));
        this.tableOfContentsEntries.get(this.mainTableOfContentPageId).add((Pair<String, PageContent>)Pair.of((Object)fluidsChapterTitle, (Object)fluidsChapterPage));
        this.addSimplePage(this.pageId("dirty_water"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.dirty_water.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n")).append((Component)Component.translatable((String)"book.energizedpower.page.dirty_water.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), EPAPI.id("textures/item/dirty_water_bucket.png"));
    }

    private void registerMachineConfigurationChapter() {
        this.chapterId("machine_configuration");
        String machineConfigurationChapterTitle = "book.energizedpower.page.chapter.machine_configuration.title";
        PageContent machineConfigurationChapterPage = this.addChapterPage(this.pageId("machine_configuration_chapter"), (Component)Component.translatable((String)machineConfigurationChapterTitle).withStyle(ChatFormatting.GOLD), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.chapter.machine_configuration")).append((Component)Component.literal((String)"\n\n").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)this.backToTableOfContentComponent(this.mainTableOfContentPageId))));
        this.tableOfContentsEntries.get(this.mainTableOfContentPageId).add((Pair<String, PageContent>)Pair.of((Object)machineConfigurationChapterTitle, (Object)machineConfigurationChapterPage));
        this.addSimplePage(this.pageId("upgrade_configuration"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.upgrade_configuration").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), EPAPI.id("textures/gui/book_icons/upgrade_view.png"));
        this.addSimplePage(this.pageId("redstone_mode_configuration"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.redstone_mode_configuration.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)).append((Component)Component.literal((String)"\n\n\u2022 ").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)Component.translatable((String)"book.energizedpower.page.redstone_mode_configuration.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM))).append((Component)Component.literal((String)"\n\n\u2022 ").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)Component.translatable((String)"book.energizedpower.page.redstone_mode_configuration.3").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM))).append((Component)Component.literal((String)"\n\n\u2022 ").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)Component.translatable((String)"book.energizedpower.page.redstone_mode_configuration.4").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM))), new ResourceLocation[]{EPAPI.id("textures/gui/book_icons/redstone_mode_ignore.png"), EPAPI.id("textures/gui/book_icons/redstone_mode_high.png"), EPAPI.id("textures/gui/book_icons/redstone_mode_low.png")});
        this.addSimplePage(this.pageId("comparator_mode_configuration"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.comparator_mode_configuration.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)).append((Component)Component.literal((String)"\n\n\u2022 ").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)Component.translatable((String)"book.energizedpower.page.comparator_mode_configuration.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM))).append((Component)Component.literal((String)"\n\n\u2022 ").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)Component.translatable((String)"book.energizedpower.page.comparator_mode_configuration.3").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM))).append((Component)Component.literal((String)"\n\n\u2022 ").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)Component.translatable((String)"book.energizedpower.page.comparator_mode_configuration.4").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM))), new ResourceLocation[]{EPAPI.id("textures/gui/book_icons/comparator_mode_item.png"), EPAPI.id("textures/gui/book_icons/comparator_mode_fluid.png"), EPAPI.id("textures/gui/book_icons/comparator_mode_energy.png")});
    }

    private void registerEntitiesChapter() {
        this.chapterId("entities");
        String entitiesChapterTitle = "book.energizedpower.page.chapter.entities.title";
        PageContent entitiesChapterPage = this.addChapterPage(this.pageId("entities_chapter"), (Component)Component.translatable((String)entitiesChapterTitle).withStyle(ChatFormatting.GOLD), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.chapter.entities")).append((Component)Component.literal((String)"\n\n").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)this.backToTableOfContentComponent(this.mainTableOfContentPageId))));
        this.tableOfContentsEntries.get(this.mainTableOfContentPageId).add((Pair<String, PageContent>)Pair.of((Object)entitiesChapterTitle, (Object)entitiesChapterPage));
        this.addSimplePage(this.pageId("battery_box_minecarts"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.battery_box_minecarts").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)), new ResourceLocation[]{EPAPI.id("textures/item/battery_box_minecart.png"), EPAPI.id("textures/item/advanced_battery_box_minecart.png")});
    }

    private void registerStructuresChapter() {
        this.chapterId("structures");
        String structuresChapterTitle = "book.energizedpower.page.chapter.structures.title";
        PageContent structuresChapterPage = this.addChapterPage(this.pageId("structures_chapter"), (Component)Component.translatable((String)structuresChapterTitle).withStyle(ChatFormatting.GOLD), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.chapter.structures")).append((Component)Component.literal((String)"\n\n").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)this.backToTableOfContentComponent(this.mainTableOfContentPageId))), (Block)EPBlocks.BASIC_MACHINE_FRAME.get());
        this.tableOfContentsEntries.get(this.mainTableOfContentPageId).add((Pair<String, PageContent>)Pair.of((Object)structuresChapterTitle, (Object)structuresChapterPage));
        this.addSimplePage(this.pageId("electrician"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.electrician.title").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).append("\n\n")).append((Component)Component.translatable((String)"book.energizedpower.page.electrician.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n\n")).append((Component)Component.translatable((String)"book.energizedpower.page.electrician.2").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append("\n\n")).append((Component)Component.translatable((String)"book.energizedpower.page.electrician.3").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)));
        this.addSimplePage(this.pageId("factory"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.factory.title").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).append("\n\n")).append((Component)Component.translatable((String)"book.energizedpower.page.factory.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)));
        this.addSimplePage(this.pageId("small_solar_farm"), (Component)Component.empty().append((Component)Component.translatable((String)"book.energizedpower.page.small_solar_farm.title").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).append("\n\n")).append((Component)Component.translatable((String)"book.energizedpower.page.small_solar_farm.1").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM)));
    }

    private void registerTableOfContentsPages() {
        this.tableOfContentsEntries.forEach((pageId, entries) -> {
            MutableComponent content = Component.translatable((String)this.tableOfContentPageTitles.get(pageId)).withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD});
            entries.forEach(entry -> content.append((Component)Component.literal((String)"\n\n\u2022 ").withStyle(new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.BOLD}).withStyle(UNIFORM).append((Component)this.tableOfContentEntryComponent((String)entry.getFirst(), (PageContent)entry.getSecond()))));
            this.addSimplePage((String)pageId, (Component)content);
        });
    }

    private MutableComponent tableOfContentEntryComponent(String chapterTitle, PageContent chapterPage) {
        return Component.translatable((String)chapterTitle).withStyle(new ChatFormatting[]{ChatFormatting.DARK_GREEN, ChatFormatting.UNDERLINE}).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.CHANGE_PAGE, chapterPage.pageId().toString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"book.energizedpower.tooltip.page"))));
    }

    private MutableComponent backToTableOfContentComponent(String tableOfContentPageId) {
        return Component.translatable((String)this.tableOfContentPageTitles.get(tableOfContentPageId)).withStyle(new ChatFormatting[]{ChatFormatting.DARK_GREEN, ChatFormatting.UNDERLINE}).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.CHANGE_PAGE, "energizedpower:" + tableOfContentPageId)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"book.energizedpower.tooltip.page"))));
    }

    private int nextChapterSortingNumber() {
        this.subChapterSortingNumber = 0;
        this.pageSortingNumber = 0;
        int i = this.chapterSortingNumber;
        this.chapterSortingNumber += 10;
        return i;
    }

    private int nextSubChapterSortingNumber() {
        this.pageSortingNumber = 0;
        int i = this.subChapterSortingNumber;
        this.subChapterSortingNumber += 10;
        return i;
    }

    private int nextPageSortingNumber() {
        int i = this.pageSortingNumber;
        this.pageSortingNumber += 10;
        return i;
    }

    private void chapterId(String chapter) {
        this.currentSubChapterIdPrefix = this.currentChapterIdPrefix = String.format("chapters/%04d_%s/", this.nextChapterSortingNumber(), chapter);
    }

    private void subChapterId(String chapter) {
        this.currentSubChapterIdPrefix = String.format("%s%04d_%s/", this.currentChapterIdPrefix, this.nextSubChapterSortingNumber(), chapter);
    }

    private String pageId(String page) {
        return String.format("%s%04d_%s", this.currentSubChapterIdPrefix, this.nextPageSortingNumber(), page);
    }
}

