/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.datagen;

import java.util.concurrent.CompletableFuture;
import me.jddev0.ep.datagen.ModAdvancementProvider;
import me.jddev0.ep.datagen.ModBiomeTagProvider;
import me.jddev0.ep.datagen.ModBlockStateProvider;
import me.jddev0.ep.datagen.ModBlockTagProvider;
import me.jddev0.ep.datagen.ModBookPageContentProvider;
import me.jddev0.ep.datagen.ModItemModelProvider;
import me.jddev0.ep.datagen.ModItemTagProvider;
import me.jddev0.ep.datagen.ModLootTableProvider;
import me.jddev0.ep.datagen.ModPaintingVariantTagProvider;
import me.jddev0.ep.datagen.ModPoiTypeTagProvider;
import me.jddev0.ep.datagen.ModRecipeProvider;
import me.jddev0.ep.datagen.ModRegistriesProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="energizedpower", bus=EventBusSubscriber.Bus.MOD)
public class EnergizedPowerDataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = ((ModRegistriesProvider)generator.addProvider(event.includeServer(), (DataProvider)new ModRegistriesProvider(output, event.getLookupProvider()))).getRegistryProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBookPageContentProvider(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)ModLootTableProvider.create(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)ModAdvancementProvider.create(output, lookupProvider, existingFileHelper));
        ModBlockTagProvider blockTagProvider = (ModBlockTagProvider)generator.addProvider(event.includeServer(), (DataProvider)new ModBlockTagProvider(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagProvider(output, lookupProvider, blockTagProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModPoiTypeTagProvider(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModBiomeTagProvider(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModPaintingVariantTagProvider(output, lookupProvider, existingFileHelper));
    }
}

